/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.http.QueryParameter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wiremock.url.PathAndQuery;
import org.wiremock.url.Query;

public class Urls {
    private Urls() {
    }

    public static Map<String, QueryParameter> toQueryParameterMap(Query query) {
        return query.asDecodedMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new QueryParameter((String)e.getKey(), (List)e.getValue())));
    }

    public static String urlToPathParts(PathAndQuery uri) {
        List<String> uriPathNodes = uri.getPath().getSegments().stream().filter(s -> !s.isEmpty()).map(Object::toString).toList();
        int nodeCount = uriPathNodes.size();
        return nodeCount > 0 ? String.join((CharSequence)"-", uriPathNodes) : "";
    }
}

