/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.FindStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.GetAllScenariosTask;
import com.github.tomakehurst.wiremock.admin.GetGlobalSettingsTask;
import com.github.tomakehurst.wiremock.admin.GetRecordingStatusTask;
import com.github.tomakehurst.wiremock.admin.ImportStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.RemoveServeEventTask;
import com.github.tomakehurst.wiremock.admin.RemoveServeEventsByRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.RemoveServeEventsByStubMetadataTask;
import com.github.tomakehurst.wiremock.admin.RemoveStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.RequestSpec;
import com.github.tomakehurst.wiremock.admin.SetScenarioStateTask;
import com.github.tomakehurst.wiremock.admin.StartRecordingTask;
import com.github.tomakehurst.wiremock.admin.StopRecordingTask;
import com.github.tomakehurst.wiremock.admin.model.GetGlobalSettingsResult;
import com.github.tomakehurst.wiremock.admin.model.GetMessageServeEventsResult;
import com.github.tomakehurst.wiremock.admin.model.GetScenariosResult;
import com.github.tomakehurst.wiremock.admin.model.GetServeEventsResult;
import com.github.tomakehurst.wiremock.admin.model.ListMessageChannelsResult;
import com.github.tomakehurst.wiremock.admin.model.ListMessageStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.ScenarioState;
import com.github.tomakehurst.wiremock.admin.model.SendChannelMessageRequest;
import com.github.tomakehurst.wiremock.admin.model.SendChannelMessageResult;
import com.github.tomakehurst.wiremock.admin.model.ServeEventQuery;
import com.github.tomakehurst.wiremock.admin.model.SingleMessageServeEventResult;
import com.github.tomakehurst.wiremock.admin.model.SingleServedStubResult;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.admin.model.WaitForMessageEventRequest;
import com.github.tomakehurst.wiremock.admin.tasks.CreateMessageStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.CreateStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.EditStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindMessageEventsTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindMessageStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForUnmatchedTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindUnmatchedRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllMessageChannelsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllMessageEventsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllMessageStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetMessageEventCountTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetMessageServeEventTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetRequestCountTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetServedStubTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetUnmatchedStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GlobalSettingsUpdateTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMatchingStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageServeEventTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageServeEventsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageServeEventsByPatternTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveStubMappingByIdTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetMessageJournalTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetMessageStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetScenariosTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetToDefaultMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.SaveMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.SendChannelMessageTask;
import com.github.tomakehurst.wiremock.admin.tasks.ShutdownServerTask;
import com.github.tomakehurst.wiremock.admin.tasks.SnapshotTask;
import com.github.tomakehurst.wiremock.admin.tasks.WaitForMessageEventTask;
import com.github.tomakehurst.wiremock.admin.tasks.WaitForMessageEventsTask;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.common.AdminException;
import com.github.tomakehurst.wiremock.common.ClientError;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.QueryParams;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpStatus;
import com.github.tomakehurst.wiremock.http.ImmutableRequest;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.client.HttpClient;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.message.ChannelType;
import com.github.tomakehurst.wiremock.message.MessageDefinition;
import com.github.tomakehurst.wiremock.message.MessagePattern;
import com.github.tomakehurst.wiremock.message.MessageStubMapping;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.recording.RecordingStatusResult;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.security.ClientAuthenticator;
import com.github.tomakehurst.wiremock.security.NotAuthorisedException;
import com.github.tomakehurst.wiremock.stubbing.StubImport;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindMessageServeEventsResult;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.FindServeEventsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.MessageServeEvent;
import com.github.tomakehurst.wiremock.verification.MessageVerificationResult;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class HttpAdminClient
implements Admin {
    private static final String ADMIN_URL_PREFIX = "%s://%s%s%s/__admin";
    private static final int NO_PORT_DEFINED = -1;
    private final String scheme;
    private final String host;
    private final int port;
    private final String urlPathPrefix;
    private final String hostHeader;
    private final ClientAuthenticator authenticator;
    private final AdminRoutes adminRoutes;
    private final HttpClient httpClient;

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix, String hostHeader, ClientAuthenticator authenticator, HttpClient httpClient) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.urlPathPrefix = urlPathPrefix;
        this.hostHeader = hostHeader;
        this.authenticator = authenticator;
        this.httpClient = httpClient;
        this.adminRoutes = AdminRoutes.forClient();
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        if (stubMapping.getRequest().hasInlineCustomMatcher()) {
            throw new AdminException("Custom matchers can't be used when administering a remote WireMock server. Use WireMockRule.stubFor() or WireMockServer.stubFor() to administer the local instance.");
        }
        this.executeRequest(this.adminRoutes.requestSpecForTask(CreateStubMappingTask.class), PathParams.empty(), stubMapping, Void.class);
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.putJsonAssertOkAndReturnBody(this.urlFor(EditStubMappingTask.class, PathParams.single("id", stubMapping.getId().toString())), Json.write(stubMapping));
    }

    @Override
    public void removeStubMapping(StubMapping stubbMapping) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(RemoveMatchingStubMappingTask.class), Json.write(stubbMapping));
    }

    @Override
    public void removeStubMapping(UUID id) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveStubMappingByIdTask.class), PathParams.single("id", id), Void.class);
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllStubMappingsTask.class), ListStubMappingsResult.class);
    }

    @Override
    public SingleStubMappingResult getStubMapping(UUID id) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetStubMappingTask.class), PathParams.single("id", id), SingleStubMappingResult.class);
    }

    @Override
    public void saveMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(SaveMappingsTask.class), null);
    }

    @Override
    public void resetAll() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetTask.class), null);
    }

    @Override
    public void resetRequests() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetRequestsTask.class));
    }

    @Override
    public void resetScenarios() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetScenariosTask.class));
    }

    @Override
    public void resetMappings() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetStubMappingsTask.class));
    }

    @Override
    public void resetToDefaultMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetToDefaultMappingsTask.class), null);
    }

    @Override
    public GetServeEventsResult getServeEvents() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllRequestsTask.class), GetServeEventsResult.class);
    }

    @Override
    public GetServeEventsResult getServeEvents(ServeEventQuery query) {
        QueryParams queryParams = new QueryParams();
        queryParams.add("unmatched", String.valueOf(query.isOnlyUnmatched()));
        if (query.getStubMappingId() != null) {
            queryParams.add("matchingStub", query.getStubMappingId().toString());
        }
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllRequestsTask.class), PathParams.empty(), queryParams, null, GetServeEventsResult.class);
    }

    @Override
    public SingleServedStubResult getServedStub(UUID id) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetServedStubTask.class), PathParams.single("id", id), SingleServedStubResult.class);
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(GetRequestCountTask.class), Json.write(requestPattern));
        return VerificationResult.from(body);
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindRequestsTask.class), Json.write(requestPattern));
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(FindUnmatchedRequestsTask.class));
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public void removeServeEvent(UUID eventId) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveServeEventTask.class), PathParams.single("id", eventId), Void.class);
    }

    @Override
    public FindServeEventsResult removeServeEventsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(RemoveServeEventsByRequestPatternTask.class), Json.write(requestPattern));
        return Json.read(body, FindServeEventsResult.class);
    }

    @Override
    public FindServeEventsResult removeServeEventsForStubsMatchingMetadata(StringValuePattern metadataPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(RemoveServeEventsByStubMetadataTask.class), Json.write(metadataPattern));
        return Json.read(body, FindServeEventsResult.class);
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForUnmatchedTask.class));
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public GetScenariosResult getAllScenarios() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllScenariosTask.class), GetScenariosResult.class);
    }

    @Override
    public void resetScenario(String name) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(SetScenarioStateTask.class), PathParams.single("name", name), Void.class);
    }

    @Override
    public void setScenarioState(String name, String state) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(SetScenarioStateTask.class), PathParams.single("name", name), new ScenarioState(state), Void.class);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForRequestTask.class), Json.write(loggedRequest));
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForRequestPatternTask.class), Json.write(requestPattern));
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public void updateGlobalSettings(GlobalSettings settings) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(GlobalSettingsUpdateTask.class), Json.write(settings));
    }

    @Override
    public SnapshotRecordResult snapshotRecord() {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(SnapshotTask.class), "");
        return Json.read(body, SnapshotRecordResult.class);
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpecBuilder spec) {
        return this.snapshotRecord(spec.build());
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpec spec) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(SnapshotTask.class), Json.write(spec));
        return Json.read(body, SnapshotRecordResult.class);
    }

    @Override
    public void startRecording(String targetBaseUrl) {
        this.startRecording(RecordSpec.forBaseUrl(targetBaseUrl));
    }

    @Override
    public void startRecording(RecordSpec recordSpec) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(StartRecordingTask.class), Json.write(recordSpec));
    }

    @Override
    public void startRecording(RecordSpecBuilder recordSpec) {
        this.startRecording(recordSpec.build());
    }

    @Override
    public SnapshotRecordResult stopRecording() {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(StopRecordingTask.class), "");
        return Json.read(body, SnapshotRecordResult.class);
    }

    @Override
    public RecordingStatusResult getRecordingStatus() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetRecordingStatusTask.class), RecordingStatusResult.class);
    }

    @Override
    public Options getOptions() {
        return new WireMockConfiguration().port(this.port).bindAddress(this.host);
    }

    @Override
    public void shutdownServer() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ShutdownServerTask.class), null);
    }

    @Override
    public ListStubMappingsResult findUnmatchedStubs() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetUnmatchedStubMappingsTask.class), ListStubMappingsResult.class);
    }

    @Override
    public ListStubMappingsResult findAllStubsByMetadata(StringValuePattern pattern) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(FindStubMappingsByMetadataTask.class), pattern, ListStubMappingsResult.class);
    }

    @Override
    public void removeStubsByMetadata(StringValuePattern pattern) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveStubMappingsByMetadataTask.class), pattern, Void.class);
    }

    @Override
    public void importStubs(StubImport stubImport) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ImportStubMappingsTask.class), stubImport, Void.class);
    }

    @Override
    public void removeStubMappings(List<StubMapping> stubMappings) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveMatchingStubMappingTask.class), Map.of("mappings", stubMappings), Void.class);
    }

    @Override
    public GetGlobalSettingsResult getGlobalSettings() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetGlobalSettingsTask.class), GetGlobalSettingsResult.class);
    }

    public int port() {
        return this.port;
    }

    private String postJsonAssertOkAndReturnBody(String url, String json) {
        ImmutableRequest.Builder post = ImmutableRequest.create().withMethod(RequestMethod.POST).withAbsoluteUrl(url);
        post.withHeader("Content-Type", "application/json");
        post.withBody(Optional.ofNullable(json).orElse("").getBytes(StandardCharsets.UTF_8));
        return this.safelyExecuteRequest(url, post);
    }

    private String putJsonAssertOkAndReturnBody(String url, String json) {
        ImmutableRequest.Builder put = ImmutableRequest.create().withMethod(RequestMethod.PUT).withAbsoluteUrl(url);
        put.withHeader("Content-Type", "application/json");
        put.withBody(Optional.ofNullable(json).orElse("").getBytes(StandardCharsets.UTF_8));
        return this.safelyExecuteRequest(url, put);
    }

    protected String getJsonAssertOkAndReturnBody(String url) {
        ImmutableRequest.Builder get = ImmutableRequest.create().withMethod(RequestMethod.GET).withAbsoluteUrl(url);
        return this.safelyExecuteRequest(url, get);
    }

    private void executeRequest(RequestSpec requestSpec) {
        this.executeRequest(requestSpec, PathParams.empty(), null, Void.class);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, B requestBody, Class<R> responseType) {
        return this.executeRequest(requestSpec, PathParams.empty(), requestBody, responseType);
    }

    private <R> R executeRequest(RequestSpec requestSpec, Class<R> responseType) {
        return this.executeRequest(requestSpec, PathParams.empty(), null, responseType);
    }

    private <R> R executeRequest(RequestSpec requestSpec, PathParams pathParams, Class<R> responseType) {
        return this.executeRequest(requestSpec, pathParams, null, responseType);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, PathParams pathParams, B requestBody, Class<R> responseType) {
        return this.executeRequest(requestSpec, pathParams, QueryParams.EMPTY, requestBody, responseType);
    }

    private <B, R> R executeRequest(RequestSpec requestSpec, PathParams pathParams, QueryParams queryParams, B requestBody, Class<R> responseType) {
        String url = this.getAdminUrl(requestSpec.path(pathParams) + String.valueOf(queryParams));
        ImmutableRequest.Builder requestBuilder = ImmutableRequest.create().withMethod(requestSpec.method()).withAbsoluteUrl(url);
        if (requestSpec.method().hasEntity()) {
            requestBuilder.withBody(Optional.ofNullable(requestBody).map(Json::write).orElse("").getBytes(StandardCharsets.UTF_8));
            requestBuilder.withHeader("Content-Type", "application/json");
        }
        String responseBodyString = this.safelyExecuteRequest(url, requestBuilder);
        return responseType == Void.class ? null : (R)Json.read(responseBodyString, responseType);
    }

    private void injectHeaders(ImmutableRequest.Builder request) {
        if (this.hostHeader != null) {
            request.withHeader("host", this.hostHeader);
        }
        List<HttpHeader> httpHeaders = this.authenticator.generateAuthHeaders();
        httpHeaders.forEach(header -> request.withHeader(header.key(), header.values()));
    }

    private void verifyResponseStatus(String url, int responseStatusCode) {
        if (HttpStatus.isServerError(responseStatusCode)) {
            throw new VerificationException(this.responseStatusErrorMessage(url, responseStatusCode));
        }
        if (responseStatusCode == 401) {
            throw new NotAuthorisedException(this.responseStatusErrorMessage(url, responseStatusCode));
        }
    }

    private String responseStatusErrorMessage(String url, int responseStatusCode) {
        return "Expected status 2xx for " + url + " but was " + responseStatusCode;
    }

    private String safelyExecuteRequest(String url, ImmutableRequest.Builder request) {
        this.injectHeaders(request);
        try {
            Response response = this.httpClient.execute(request.build());
            int statusCode = response.getStatus();
            this.verifyResponseStatus(url, statusCode);
            String body = response.getBodyAsString();
            if (HttpStatus.isClientError(statusCode)) {
                throw HttpAdminClient.parseClientError(url, body, statusCode);
            }
            return body;
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    static ClientError parseClientError(String url, String responseBody, int responseStatusCode) {
        Errors errors;
        try {
            errors = Json.read(responseBody, Errors.class);
        }
        catch (JsonException e) {
            Errors.Error jsonError = e.getErrors().first();
            String jsonErrorDetail = jsonError.getDetail();
            String extendedDetail = "Error parsing response body '" + responseBody + "' with status code " + responseStatusCode + " for " + url + ". Error: " + jsonErrorDetail;
            errors = Errors.single(jsonError.getCode(), jsonError.getSource().getPointer(), jsonError.getTitle(), extendedDetail);
        }
        return ClientError.fromErrors(errors);
    }

    private String urlFor(Class<? extends AdminTask> taskClass) {
        return this.urlFor(taskClass, PathParams.empty());
    }

    private String urlFor(Class<? extends AdminTask> taskClass, PathParams pathParams) {
        RequestSpec requestSpec = this.adminRoutes.requestSpecForTask(taskClass);
        Objects.requireNonNull(requestSpec, "No admin task URL is registered for " + taskClass.getSimpleName());
        return this.getAdminUrl(requestSpec.path(pathParams));
    }

    private String getAdminUrl(String pathSuffix) {
        String portPart = this.port == -1 ? "" : ":" + this.port;
        return String.format(ADMIN_URL_PREFIX + pathSuffix, this.scheme, this.host, portPart, this.urlPathPrefix);
    }

    @Override
    public SendChannelMessageResult sendChannelMessage(ChannelType type, RequestPattern requestPattern, MessageDefinition message) {
        String url = this.urlFor(SendChannelMessageTask.class);
        String body = Json.write(new SendChannelMessageRequest(type, requestPattern, message));
        String response = this.postJsonAssertOkAndReturnBody(url, body);
        return Json.read(response, SendChannelMessageResult.class);
    }

    @Override
    public ListMessageChannelsResult listAllMessageChannels() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllMessageChannelsTask.class), ListMessageChannelsResult.class);
    }

    @Override
    public void addMessageStubMapping(MessageStubMapping messageStubMapping) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(CreateMessageStubMappingTask.class), Json.write(messageStubMapping));
    }

    @Override
    public void removeMessageStubMapping(UUID id) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveMessageStubMappingTask.class), PathParams.single("id", id), Void.class);
    }

    @Override
    public void resetMessageStubMappings() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetMessageStubMappingsTask.class));
    }

    @Override
    public ListMessageStubMappingsResult findAllMessageStubsByMetadata(StringValuePattern pattern) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(FindMessageStubMappingsByMetadataTask.class), pattern, ListMessageStubMappingsResult.class);
    }

    @Override
    public void removeMessageStubsByMetadata(StringValuePattern pattern) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveMessageStubMappingsByMetadataTask.class), pattern, Void.class);
    }

    @Override
    public ListMessageStubMappingsResult listAllMessageStubMappings() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllMessageStubMappingsTask.class), ListMessageStubMappingsResult.class);
    }

    @Override
    public GetMessageServeEventsResult getMessageServeEvents() {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetAllMessageEventsTask.class), GetMessageServeEventsResult.class);
    }

    @Override
    public SingleMessageServeEventResult getMessageServeEvent(UUID id) {
        return this.executeRequest(this.adminRoutes.requestSpecForTask(GetMessageServeEventTask.class), PathParams.single("id", id), SingleMessageServeEventResult.class);
    }

    @Override
    public int countMessageEventsMatching(MessagePattern pattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(GetMessageEventCountTask.class), Json.write(pattern));
        return MessageVerificationResult.from(body).getCount();
    }

    @Override
    public List<MessageServeEvent> findMessageEventsMatching(MessagePattern pattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindMessageEventsTask.class), Json.write(pattern));
        return Json.read(body, FindMessageServeEventsResult.class).getMessageServeEvents();
    }

    @Override
    public void removeMessageServeEvent(UUID eventId) {
        this.executeRequest(this.adminRoutes.requestSpecForTask(RemoveMessageServeEventTask.class), PathParams.single("id", eventId), Void.class);
    }

    @Override
    public FindMessageServeEventsResult removeMessageServeEventsMatching(MessagePattern pattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(RemoveMessageServeEventsByPatternTask.class), Json.write(pattern));
        return Json.read(body, FindMessageServeEventsResult.class);
    }

    @Override
    public FindMessageServeEventsResult removeMessageServeEventsForStubsMatchingMetadata(StringValuePattern pattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(RemoveMessageServeEventsByMetadataTask.class), Json.write(pattern));
        return Json.read(body, FindMessageServeEventsResult.class);
    }

    @Override
    public void resetMessageJournal() {
        this.executeRequest(this.adminRoutes.requestSpecForTask(ResetMessageJournalTask.class));
    }

    @Override
    public Optional<MessageServeEvent> waitForMessageEvent(MessagePattern pattern, Duration maxWait) {
        WaitForMessageEventRequest request = WaitForMessageEventRequest.forSingleEvent(pattern, maxWait.toMillis());
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(WaitForMessageEventTask.class), Json.write(request));
        SingleMessageServeEventResult result = Json.read(body, SingleMessageServeEventResult.class);
        return result != null ? Optional.ofNullable((MessageServeEvent)result.getItem()) : Optional.empty();
    }

    @Override
    public List<MessageServeEvent> waitForMessageEvents(MessagePattern pattern, int count, Duration maxWait) {
        WaitForMessageEventRequest request = WaitForMessageEventRequest.forMultipleEvents(pattern, maxWait.toMillis(), count);
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(WaitForMessageEventsTask.class), Json.write(request));
        return Json.read(body, GetMessageServeEventsResult.class).getMessageServeEvents();
    }
}

