/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.message.MessagePattern;
import com.github.tomakehurst.wiremock.message.MessageStubMapping;
import com.github.tomakehurst.wiremock.store.MessageJournalStore;
import com.github.tomakehurst.wiremock.store.StoreEvent;
import com.github.tomakehurst.wiremock.verification.MessageJournal;
import com.github.tomakehurst.wiremock.verification.MessageServeEvent;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class StoreBackedMessageJournal
implements MessageJournal {
    protected final MessageJournalStore store;
    private final Integer maxEntries;

    public StoreBackedMessageJournal(Integer maxEntries, MessageJournalStore store) {
        if (maxEntries != null && maxEntries < 0) {
            throw new IllegalArgumentException("Maximum number of entries of journal must be greater than zero");
        }
        this.maxEntries = maxEntries;
        this.store = store;
    }

    @Override
    public int countEventsMatching(MessagePattern pattern) {
        return (int)this.store.getAll().filter(pattern::matches).count();
    }

    @Override
    public List<MessageServeEvent> getEventsMatching(MessagePattern pattern) {
        List<MessageServeEvent> events = this.store.getAll().filter(pattern::matches).collect(Collectors.toList());
        Collections.reverse(events);
        return events;
    }

    @Override
    public List<MessageServeEvent> getAllMessageServeEvents() {
        return this.store.getAll().collect(Collectors.toList());
    }

    @Override
    public Optional<MessageServeEvent> getMessageServeEvent(UUID id) {
        return this.store.get(id);
    }

    @Override
    public void reset() {
        this.store.clear();
    }

    @Override
    public void messageReceived(MessageServeEvent event) {
        this.store.add(event);
        this.removeOldEntries();
    }

    @Override
    public void removeEvent(UUID eventId) {
        this.store.remove(eventId);
    }

    @Override
    public List<MessageServeEvent> removeEventsMatching(MessagePattern pattern) {
        List<MessageServeEvent> toDelete = this.store.getAll().filter(pattern::matches).collect(Collectors.toList());
        for (MessageServeEvent event : toDelete) {
            this.store.remove(event.getId());
        }
        return toDelete;
    }

    @Override
    public List<MessageServeEvent> removeEventsForStubsMatchingMetadata(StringValuePattern metadataPattern) {
        return this.removeEventsMatching(StoreBackedMessageJournal.withStubMetadataMatching(metadataPattern));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<MessageServeEvent> waitForEvent(MessagePattern pattern, Duration maxWait) {
        Optional<MessageServeEvent> existing = this.store.getAll().filter(pattern::matches).findFirst();
        if (existing.isPresent()) {
            return existing;
        }
        CountDownLatch latch = new CountDownLatch(1);
        MessageServeEvent[] result = new MessageServeEvent[1];
        Consumer<StoreEvent> listener = storeEvent -> {
            if (storeEvent.getNewValue() != null && pattern.matches((MessageServeEvent)storeEvent.getNewValue())) {
                result[0] = (MessageServeEvent)storeEvent.getNewValue();
                latch.countDown();
            }
        };
        this.store.registerEventListener(listener);
        try {
            boolean found = latch.await(maxWait.toMillis(), TimeUnit.MILLISECONDS);
            if (found) {
                Optional<MessageServeEvent> optional = Optional.ofNullable(result[0]);
                return optional;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.store.unregisterEventListener(listener);
        }
        return this.store.getAll().filter(pattern::matches).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageServeEvent> waitForEvents(MessagePattern pattern, int count, Duration maxWait) {
        long deadline = System.currentTimeMillis() + maxWait.toMillis();
        while (System.currentTimeMillis() < deadline) {
            List current = this.store.getAll().filter(pattern::matches).collect(Collectors.toList());
            if (current.size() >= count) {
                return current.subList(0, count);
            }
            long remaining = deadline - System.currentTimeMillis();
            if (remaining <= 0L) continue;
            CountDownLatch latch = new CountDownLatch(1);
            Consumer<StoreEvent> listener = storeEvent -> {
                if (storeEvent.getNewValue() != null && pattern.matches((MessageServeEvent)storeEvent.getNewValue())) {
                    latch.countDown();
                }
            };
            this.store.registerEventListener(listener);
            try {
                latch.await(Math.min(remaining, 100L), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            finally {
                this.store.unregisterEventListener(listener);
            }
        }
        return this.store.getAll().filter(pattern::matches).limit(count).collect(Collectors.toList());
    }

    private void removeOldEntries() {
        if (this.maxEntries != null) {
            while (this.store.getAllKeys().count() > (long)this.maxEntries.intValue()) {
                this.store.removeLast();
            }
        }
    }

    private static MessagePattern withStubMetadataMatching(final StringValuePattern metadataPattern) {
        return new MessagePattern(null, null){

            @Override
            public boolean matches(MessageServeEvent event) {
                MessageStubMapping stub = event.getStubMapping();
                if (stub != null) {
                    String metadataJson = Json.write(stub.getMetadata());
                    return metadataPattern.match(metadataJson).isExactMatch();
                }
                return false;
            }
        };
    }
}

