/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.message.ChannelType;
import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.message.RequestInitiatedMessageChannel;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.UUID;

public class LoggedMessageChannel {
    private final UUID id;
    private final ChannelType type;
    private final LoggedRequest initiatingRequest;
    private final boolean open;

    @JsonCreator
    public LoggedMessageChannel(@JsonProperty(value="id") UUID id, @JsonProperty(value="type") ChannelType type, @JsonProperty(value="initiatingRequest") LoggedRequest initiatingRequest, @JsonProperty(value="open") boolean open) {
        this.id = id;
        this.type = type;
        this.initiatingRequest = initiatingRequest;
        this.open = open;
    }

    public static LoggedMessageChannel createFrom(MessageChannel channel) {
        LoggedRequest loggedRequest = null;
        if (channel instanceof RequestInitiatedMessageChannel) {
            loggedRequest = LoggedRequest.createFrom(((RequestInitiatedMessageChannel)channel).getInitiatingRequest());
        }
        return new LoggedMessageChannel(channel.getId(), channel.getType(), loggedRequest, channel.isOpen());
    }

    public UUID getId() {
        return this.id;
    }

    public ChannelType getType() {
        return this.type;
    }

    public LoggedRequest getInitiatingRequest() {
        return this.initiatingRequest;
    }

    @JsonProperty(value="open")
    public boolean isOpen() {
        return this.open;
    }
}

