/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.message.MessageChannel;
import com.github.tomakehurst.wiremock.store.MessageChannelStore;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.wiremock.annotations.Beta;

@Beta(justification="Externalized State API: https://github.com/wiremock/wiremock/issues/2144")
public class InMemoryMessageChannelStore
implements MessageChannelStore {
    private final Map<UUID, MessageChannel> channels = new ConcurrentHashMap<UUID, MessageChannel>();

    @Override
    public Stream<MessageChannel> getAll() {
        return this.channels.values().stream();
    }

    @Override
    public Optional<MessageChannel> get(UUID id) {
        return Optional.ofNullable(this.channels.get(id));
    }

    @Override
    public void add(MessageChannel channel) {
        this.channels.put(channel.getId(), channel);
    }

    @Override
    public Optional<MessageChannel> remove(UUID id) {
        return Optional.ofNullable(this.channels.remove(id));
    }

    @Override
    public void clear() {
        this.channels.clear();
    }
}

