/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionDeclarations;
import com.github.tomakehurst.wiremock.extension.ExtensionFactory;
import com.github.tomakehurst.wiremock.extension.ExtensionLoader;
import com.github.tomakehurst.wiremock.extension.StaticExtensionLoader;
import com.github.tomakehurst.wiremock.extension.TemplateHelperProviderExtension;
import com.github.tomakehurst.wiremock.extension.TemplateModelDataProviderExtension;
import com.github.tomakehurst.wiremock.extension.WireMockServices;
import com.github.tomakehurst.wiremock.extension.responsetemplating.LazyTemplateEngine;
import com.github.tomakehurst.wiremock.extension.responsetemplating.MessageTemplateTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.http.client.HttpClient;
import com.github.tomakehurst.wiremock.http.client.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.client.LazyHttpClient;
import com.github.tomakehurst.wiremock.http.client.LazyHttpClientFactory;
import com.github.tomakehurst.wiremock.proxy.ProxiedHostnameRewriteResponseTransformer;
import com.github.tomakehurst.wiremock.store.Stores;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wiremock.webhooks.WebhookTransformer;
import org.wiremock.webhooks.Webhooks;

public class Extensions
implements WireMockServices {
    public static final Extensions NONE = new Extensions(new ExtensionDeclarations(), null, null, null, null);
    private final ExtensionDeclarations extensionDeclarations;
    private final Admin admin;
    private final Options options;
    private final Stores stores;
    private final FileSource files;
    private TemplateEngine templateEngine;
    private HttpClientFactory httpClientFactory;
    private final Map<String, Extension> loadedExtensions;

    public Extensions(ExtensionDeclarations extensionDeclarations, Admin admin, Options options, Stores stores, FileSource files) {
        this.extensionDeclarations = extensionDeclarations;
        this.admin = admin;
        this.options = options;
        this.stores = stores;
        this.files = files;
        this.loadedExtensions = new LinkedHashMap<String, Extension>();
    }

    public void load() {
        Stream.concat(this.extensionDeclarations.getClassNames().stream().map(Extensions::loadClass), this.extensionDeclarations.getClasses().stream()).map(Extensions::load).forEach(extension -> {
            if (this.loadedExtensions.containsKey(extension.getName())) {
                throw new IllegalArgumentException("Duplicate extension name: " + extension.getName());
            }
            this.loadedExtensions.put(extension.getName(), (Extension)extension);
        });
        this.loadedExtensions.putAll(this.extensionDeclarations.getInstances());
        if (this.options.isExtensionScanningEnabled()) {
            this.loadedExtensions.putAll(this.loadExtensionsAsServices().collect(Collectors.toMap(Extension::getName, Function.identity(), (e1, e2) -> {
                throw new IllegalStateException("Duplicate extension name: " + e1.getName());
            }, LinkedHashMap::new)));
        }
        Stream<ExtensionFactory> declaredFactories = Stream.concat(this.extensionDeclarations.getFactories().stream(), this.extensionDeclarations.getFactoryClasses().stream().map(Extensions::instantiateExtensionFactory));
        Stream<ExtensionFactory> allFactories = this.options.isExtensionScanningEnabled() ? Stream.concat(declaredFactories, this.loadExtensionFactoriesAsServices()) : declaredFactories;
        this.loadedExtensions.putAll(allFactories.map(factory -> factory.create(this)).flatMap(Collection::stream).collect(Collectors.toMap(Extension::getName, Function.identity(), (e1, e2) -> {
            throw new IllegalStateException("Duplicate extension name: " + e1.getName());
        }, LinkedHashMap::new)));
        this.configureTemplating();
        this.configureHttpClient();
        this.configureWebhooks();
        this.configureProxiedHostnameRewrite();
    }

    private Stream<Extension> loadExtensionsAsServices() {
        ServiceLoader<Extension> loader = ServiceLoader.load(Extension.class);
        return loader.stream().map(ServiceLoader.Provider::get);
    }

    private Stream<ExtensionFactory> loadExtensionFactoriesAsServices() {
        ServiceLoader<ExtensionFactory> loader = ServiceLoader.load(ExtensionFactory.class);
        return loader.stream().map(ServiceLoader.Provider::get).filter(ExtensionFactory::isLoadable);
    }

    private void configureTemplating() {
        Map helpers = this.ofType(TemplateHelperProviderExtension.class).values().stream().map(TemplateHelperProviderExtension::provideTemplateHelpers).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> {
            throw new IllegalStateException("Duplicate key");
        }, LinkedHashMap::new));
        ArrayList<TemplateModelDataProviderExtension> templateModelProviders = new ArrayList<TemplateModelDataProviderExtension>(this.ofType(TemplateModelDataProviderExtension.class).values());
        this.templateEngine = new TemplateEngine(helpers, this.options.getMaxTemplateCacheEntries(), this.options.getTemplatePermittedSystemKeys(), this.options.getTemplateEscapingDisabled(), templateModelProviders);
        if (this.options.getResponseTemplatingEnabled()) {
            ResponseTemplateTransformer responseTemplateTransformer = new ResponseTemplateTransformer(this.getTemplateEngine(), this.options.getResponseTemplatingGlobal(), this.getFiles(), templateModelProviders);
            this.loadedExtensions.put(responseTemplateTransformer.getName(), responseTemplateTransformer);
            MessageTemplateTransformer messageTemplateTransformer = new MessageTemplateTransformer(this.getTemplateEngine());
            this.loadedExtensions.put(messageTemplateTransformer.getName(), messageTemplateTransformer);
        }
    }

    private void configureHttpClient() {
        this.httpClientFactory = new StaticExtensionLoader<HttpClientFactory>(HttpClientFactory.class).setSpecificInstance(this.options.httpClientFactory()).setExtensions(this).load();
    }

    private void configureWebhooks() {
        List<WebhookTransformer> webhookTransformers = this.ofType(WebhookTransformer.class).values().stream().toList();
        Webhooks webhooks = new Webhooks(this, Executors.newScheduledThreadPool(this.options.getWebhookThreadPoolSize()), webhookTransformers);
        this.loadedExtensions.put(webhooks.getName(), webhooks);
    }

    private void configureProxiedHostnameRewrite() {
        ProxiedHostnameRewriteResponseTransformer proxiedHostnameRewriteTransformer = new ProxiedHostnameRewriteResponseTransformer();
        this.loadedExtensions.put(proxiedHostnameRewriteTransformer.getName(), proxiedHostnameRewriteTransformer);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public Stores getStores() {
        return this.stores;
    }

    @Override
    public FileSource getFiles() {
        return this.files;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public Extensions getExtensions() {
        return this;
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        return new LazyTemplateEngine(() -> this.templateEngine);
    }

    @Override
    public HttpClientFactory getHttpClientFactory() {
        return new LazyHttpClientFactory(() -> this.httpClientFactory);
    }

    @Override
    public HttpClient getDefaultHttpClient() {
        return new LazyHttpClient(() -> this.httpClientFactory.buildHttpClient(this.options, true, Collections.emptyList(), true));
    }

    public int getCount() {
        return this.loadedExtensions.size();
    }

    public Set<String> getAllExtensionNames() {
        return this.loadedExtensions.keySet();
    }

    private static Class<? extends Extension> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return Exceptions.throwUnchecked(e, Class.class);
        }
    }

    public static Extension load(Class<? extends Extension> extensionClass) {
        try {
            return extensionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, Extension.class);
        }
    }

    public void startAll() {
        this.loadedExtensions.values().forEach(Extension::start);
    }

    public void stopAll() {
        this.loadedExtensions.values().forEach(Extension::stop);
    }

    public <T extends Extension> Map<String, T> ofType(Class<T> extensionType) {
        return Collections.unmodifiableMap(this.loadedExtensions.entrySet().stream().filter(ExtensionLoader.valueAssignableFrom(extensionType)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (entry1, entry2) -> entry1, LinkedHashMap::new)));
    }

    private static ExtensionFactory instantiateExtensionFactory(Class<? extends ExtensionFactory> factoryClass) {
        return Exceptions.uncheck(() -> (ExtensionFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), ExtensionFactory.class);
    }
}

