/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.entity.CompressionType;
import com.github.tomakehurst.wiremock.common.entity.EncodingType;
import com.github.tomakehurst.wiremock.common.entity.EntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.FormatType;
import java.util.Arrays;
import java.util.Objects;

@JsonDeserialize(as=TextEntityDefinition.class)
public class TextEntityDefinition
extends EntityDefinition {
    public static final FormatType DEFAULT_FORMAT = FormatType.JSON;
    public static final CompressionType DEFAULT_COMPRESSION = CompressionType.NONE;
    private final FormatType format;
    private final CompressionType compression;
    private final String dataStore;
    private final String dataRef;
    private final Object data;
    private final String filePath;

    public TextEntityDefinition(@JsonProperty(value="format") FormatType format, @JsonProperty(value="compression") CompressionType compression, @JsonProperty(value="dataStore") String dataStore, @JsonProperty(value="dataRef") String dataRef, @JsonProperty(value="data") Object data, @JsonProperty(value="filePath") String filePath) {
        this.format = Arrays.asList(FormatType.values()).contains(format) ? format : DEFAULT_FORMAT;
        this.compression = Arrays.asList(CompressionType.values()).contains(compression) ? compression : DEFAULT_COMPRESSION;
        this.dataStore = dataStore;
        this.dataRef = dataRef;
        this.data = data;
        this.filePath = filePath;
    }

    public static Builder aTextMessage() {
        return new Builder();
    }

    @Override
    @JsonIgnore
    public EncodingType getEncoding() {
        return EncodingType.TEXT;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=DefaultFormatFilter.class)
    public FormatType getFormat() {
        return this.format;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=DefaultCompressionFilter.class)
    public CompressionType getCompression() {
        return this.compression;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getDataRef() {
        return this.dataRef;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextEntityDefinition that = (TextEntityDefinition)o;
        return Objects.equals(this.format, that.format) && Objects.equals(this.compression, that.compression) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.dataRef, that.dataRef) && Objects.equals(this.data, that.data) && Objects.equals(this.filePath, that.filePath);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.compression, this.dataStore, this.dataRef, this.data, this.filePath);
    }

    public String toString() {
        return Json.write(this);
    }

    public static class Builder
    implements EntityDefinition.Builder<TextEntityDefinition> {
        private FormatType format;
        private CompressionType compression;
        private String dataStore;
        private String dataRef;
        private Object data;
        private String filePath;

        public Builder withFormat(FormatType format) {
            this.format = format;
            return this;
        }

        public Builder withCompression(CompressionType compression) {
            this.compression = compression;
            return this;
        }

        public Builder withDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder withDataRef(String dataRef) {
            this.dataRef = dataRef;
            return this;
        }

        public Builder withBody(Object data) {
            this.data = data;
            return this;
        }

        public Builder withFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        @Override
        public TextEntityDefinition build() {
            return new TextEntityDefinition(this.format, this.compression, this.dataStore, this.dataRef, this.data, this.filePath);
        }
    }

    public static class DefaultCompressionFilter {
        public boolean equals(Object obj) {
            return DEFAULT_COMPRESSION.equals(obj);
        }
    }

    public static class DefaultFormatFilter {
        public boolean equals(Object obj) {
            return DEFAULT_FORMAT.equals(obj);
        }
    }
}

