/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.entity.CompressionType;
import com.github.tomakehurst.wiremock.common.entity.EncodingType;
import com.github.tomakehurst.wiremock.common.entity.EntityDefinition;
import com.github.tomakehurst.wiremock.common.entity.FormatType;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

@JsonDeserialize(as=BinaryEntityDefinition.class)
public class BinaryEntityDefinition
extends EntityDefinition {
    public static final CompressionType DEFAULT_COMPRESSION = CompressionType.NONE;
    private final CompressionType compression;
    private final String dataStore;
    private final String dataRef;
    private final String data;
    private final String filePath;

    public BinaryEntityDefinition(@JsonProperty(value="encoding") EncodingType ignored, @JsonProperty(value="compression") CompressionType compression, @JsonProperty(value="dataStore") String dataStore, @JsonProperty(value="dataRef") String dataRef, @JsonProperty(value="data") String data, @JsonProperty(value="filePath") String filePath) {
        this.compression = Arrays.asList(CompressionType.values()).contains(compression) ? compression : DEFAULT_COMPRESSION;
        this.dataStore = dataStore;
        this.dataRef = dataRef;
        this.data = data;
        this.filePath = filePath;
    }

    public static Builder aBinaryMessage() {
        return new Builder();
    }

    @Override
    public EncodingType getEncoding() {
        return EncodingType.BINARY;
    }

    @Override
    @JsonIgnore
    public FormatType getFormat() {
        return FormatType.BASE64;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=DefaultCompressionFilter.class)
    public CompressionType getCompression() {
        return this.compression;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getDataRef() {
        return this.dataRef;
    }

    @Override
    public String getData() {
        return this.data;
    }

    @JsonIgnore
    public byte[] getDataAsBytes() {
        if (this.data == null) {
            return null;
        }
        return Base64.getDecoder().decode(this.data);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryEntityDefinition that = (BinaryEntityDefinition)o;
        return Objects.equals(this.compression, that.compression) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.dataRef, that.dataRef) && Objects.equals(this.data, that.data) && Objects.equals(this.filePath, that.filePath);
    }

    public int hashCode() {
        return Objects.hash(this.compression, this.dataStore, this.dataRef, this.data, this.filePath);
    }

    public String toString() {
        return Json.write(this);
    }

    public static class Builder
    implements EntityDefinition.Builder<BinaryEntityDefinition> {
        private CompressionType compression;
        private String dataStore;
        private String dataRef;
        private String data;
        private String filePath;

        public Builder withCompression(CompressionType compression) {
            this.compression = compression;
            return this;
        }

        public Builder withDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder withDataRef(String dataRef) {
            this.dataRef = dataRef;
            return this;
        }

        public Builder withBody(byte[] data) {
            this.data = data != null ? Base64.getEncoder().encodeToString(data) : null;
            return this;
        }

        public Builder withBodyBase64(String base64Data) {
            this.data = base64Data;
            return this;
        }

        public Builder withFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        @Override
        public BinaryEntityDefinition build() {
            return new BinaryEntityDefinition(null, this.compression, this.dataStore, this.dataRef, this.data, this.filePath);
        }
    }

    public static class DefaultCompressionFilter {
        public boolean equals(Object obj) {
            return DEFAULT_COMPRESSION.equals(obj);
        }
    }
}

