/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.FindStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.GetAllScenariosTask;
import com.github.tomakehurst.wiremock.admin.GetGlobalSettingsTask;
import com.github.tomakehurst.wiremock.admin.GetRecordingStatusTask;
import com.github.tomakehurst.wiremock.admin.ImportStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.admin.PatchExtendedSettingsTask;
import com.github.tomakehurst.wiremock.admin.RemoveServeEventTask;
import com.github.tomakehurst.wiremock.admin.RemoveServeEventsByRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.RemoveServeEventsByStubMetadataTask;
import com.github.tomakehurst.wiremock.admin.RemoveStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.RequestSpec;
import com.github.tomakehurst.wiremock.admin.Router;
import com.github.tomakehurst.wiremock.admin.SetScenarioStateTask;
import com.github.tomakehurst.wiremock.admin.StartRecordingTask;
import com.github.tomakehurst.wiremock.admin.StopRecordingTask;
import com.github.tomakehurst.wiremock.admin.tasks.CreateMessageStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.CreateStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.DeleteStubFileTask;
import com.github.tomakehurst.wiremock.admin.tasks.EditStubFileTask;
import com.github.tomakehurst.wiremock.admin.tasks.EditStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindMessageEventsTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindMessageStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForRequestTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindNearMissesForUnmatchedTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.FindUnmatchedRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllMessageChannelsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllMessageEventsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllMessageStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllStubFilesTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetAllStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetCaCertTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetDocIndexTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetMessageEventCountTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetMessageServeEventTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetRecordingsIndexTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetRequestCountTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetServedStubTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetStubFileTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetSwaggerSpecTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetUnmatchedStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.GetVersionTask;
import com.github.tomakehurst.wiremock.admin.tasks.GlobalSettingsUpdateTask;
import com.github.tomakehurst.wiremock.admin.tasks.HealthCheckTask;
import com.github.tomakehurst.wiremock.admin.tasks.NotFoundAdminTask;
import com.github.tomakehurst.wiremock.admin.tasks.OldEditStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMatchingStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageServeEventTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageServeEventsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageServeEventsByPatternTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageStubMappingTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveMessageStubMappingsByMetadataTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveStubMappingByIdTask;
import com.github.tomakehurst.wiremock.admin.tasks.RemoveUnmatchedStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetMessageJournalTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetMessageStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetRequestsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetScenariosTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetStubMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetTask;
import com.github.tomakehurst.wiremock.admin.tasks.ResetToDefaultMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.RootRedirectTask;
import com.github.tomakehurst.wiremock.admin.tasks.RootTask;
import com.github.tomakehurst.wiremock.admin.tasks.SaveMappingsTask;
import com.github.tomakehurst.wiremock.admin.tasks.SendChannelMessageTask;
import com.github.tomakehurst.wiremock.admin.tasks.ShutdownServerTask;
import com.github.tomakehurst.wiremock.admin.tasks.SnapshotTask;
import com.github.tomakehurst.wiremock.admin.tasks.WaitForMessageEventTask;
import com.github.tomakehurst.wiremock.admin.tasks.WaitForMessageEventsTask;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.store.Stores;
import com.google.common.collect.ImmutableBiMap;
import java.util.Collections;
import java.util.Map;

public class AdminRoutes {
    private final ImmutableBiMap<RequestSpec, AdminTask> routes;
    private final Iterable<AdminApiExtension> apiExtensions;
    private final Stores stores;

    public static AdminRoutes forClient() {
        return new AdminRoutes(Collections.emptyList(), null);
    }

    public static AdminRoutes forServer(Iterable<AdminApiExtension> apiExtensions, Stores stores) {
        return new AdminRoutes(apiExtensions, stores);
    }

    protected AdminRoutes(Iterable<AdminApiExtension> apiExtensions, Stores stores) {
        this.apiExtensions = apiExtensions;
        this.stores = stores;
        RouteBuilder routeBuilder = new RouteBuilder();
        this.initDefaultRoutes(routeBuilder);
        this.initAdditionalRoutes(routeBuilder);
        this.routes = routeBuilder.build();
    }

    private void initDefaultRoutes(Router router) {
        router.add(RequestMethod.GET, "/", new RootTask());
        router.add(RequestMethod.GET, "", new RootRedirectTask());
        router.add(RequestMethod.POST, "/reset", new ResetTask());
        router.add(RequestMethod.GET, "/mappings", new GetAllStubMappingsTask());
        router.add(RequestMethod.POST, "/mappings", new CreateStubMappingTask());
        router.add(RequestMethod.DELETE, "/mappings", new ResetStubMappingsTask());
        router.add(RequestMethod.POST, "/mappings/edit", new OldEditStubMappingTask());
        router.add(RequestMethod.POST, "/mappings/save", new SaveMappingsTask());
        router.add(RequestMethod.POST, "/mappings/reset", new ResetToDefaultMappingsTask());
        router.add(RequestMethod.GET, "/mappings/unmatched", new GetUnmatchedStubMappingsTask());
        router.add(RequestMethod.DELETE, "/mappings/unmatched", new RemoveUnmatchedStubMappingsTask());
        router.add(RequestMethod.GET, "/mappings/{id}", new GetStubMappingTask());
        router.add(RequestMethod.PUT, "/mappings/{id}", new EditStubMappingTask());
        router.add(RequestMethod.POST, "/mappings/remove", new RemoveMatchingStubMappingTask());
        router.add(RequestMethod.DELETE, "/mappings/{id}", new RemoveStubMappingByIdTask());
        router.add(RequestMethod.POST, "/mappings/find-by-metadata", new FindStubMappingsByMetadataTask());
        router.add(RequestMethod.POST, "/mappings/remove-by-metadata", new RemoveStubMappingsByMetadataTask());
        router.add(RequestMethod.POST, "/mappings/import", new ImportStubMappingsTask());
        router.add(RequestMethod.GET, "/files", new GetAllStubFilesTask(this.stores));
        router.add(RequestMethod.PUT, "/files/**", new EditStubFileTask(this.stores));
        router.add(RequestMethod.DELETE, "/files/**", new DeleteStubFileTask(this.stores));
        router.add(RequestMethod.GET, "/files/**", new GetStubFileTask(this.stores));
        router.add(RequestMethod.GET, "/scenarios", new GetAllScenariosTask());
        router.add(RequestMethod.POST, "/scenarios/reset", new ResetScenariosTask());
        router.add(RequestMethod.PUT, "/scenarios/{name}/state", new SetScenarioStateTask());
        router.add(RequestMethod.GET, "/requests", new GetAllRequestsTask());
        router.add(RequestMethod.DELETE, "/requests", new ResetRequestsTask());
        router.add(RequestMethod.POST, "/requests/count", new GetRequestCountTask());
        router.add(RequestMethod.POST, "/requests/find", new FindRequestsTask());
        router.add(RequestMethod.GET, "/requests/unmatched", new FindUnmatchedRequestsTask());
        router.add(RequestMethod.GET, "/requests/unmatched/near-misses", new FindNearMissesForUnmatchedTask());
        router.add(RequestMethod.GET, "/requests/{id}", new GetServedStubTask());
        router.add(RequestMethod.DELETE, "/requests/{id}", new RemoveServeEventTask());
        router.add(RequestMethod.POST, "/requests/remove", new RemoveServeEventsByRequestPatternTask());
        router.add(RequestMethod.POST, "/requests/remove-by-metadata", new RemoveServeEventsByStubMetadataTask());
        router.add(RequestMethod.POST, "/recordings/snapshot", new SnapshotTask());
        router.add(RequestMethod.POST, "/recordings/start", new StartRecordingTask());
        router.add(RequestMethod.POST, "/recordings/stop", new StopRecordingTask());
        router.add(RequestMethod.GET, "/recordings/status", new GetRecordingStatusTask());
        router.add(RequestMethod.GET, "/recorder", new GetRecordingsIndexTask());
        router.add(RequestMethod.POST, "/near-misses/request", new FindNearMissesForRequestTask());
        router.add(RequestMethod.POST, "/near-misses/request-pattern", new FindNearMissesForRequestPatternTask());
        router.add(RequestMethod.GET, "/settings", new GetGlobalSettingsTask());
        router.add(RequestMethod.PUT, "/settings", new GlobalSettingsUpdateTask());
        router.add(RequestMethod.POST, "/settings", new GlobalSettingsUpdateTask());
        router.add(RequestMethod.PATCH, "/settings/extended", new PatchExtendedSettingsTask());
        router.add(RequestMethod.POST, "/shutdown", new ShutdownServerTask());
        router.add(RequestMethod.GET, "/docs/swagger", new GetSwaggerSpecTask());
        router.add(RequestMethod.GET, "/docs", new GetDocIndexTask());
        router.add(RequestMethod.GET, "/certs/wiremock-ca.crt", new GetCaCertTask());
        router.add(RequestMethod.GET, "/health", new HealthCheckTask());
        router.add(RequestMethod.GET, "/version", new GetVersionTask());
        router.add(RequestMethod.GET, "/channels", new GetAllMessageChannelsTask());
        router.add(RequestMethod.POST, "/channels/send", new SendChannelMessageTask());
        router.add(RequestMethod.GET, "/messages", new GetAllMessageEventsTask());
        router.add(RequestMethod.DELETE, "/messages", new ResetMessageJournalTask());
        router.add(RequestMethod.POST, "/messages/count", new GetMessageEventCountTask());
        router.add(RequestMethod.POST, "/messages/find", new FindMessageEventsTask());
        router.add(RequestMethod.POST, "/messages/remove", new RemoveMessageServeEventsByPatternTask());
        router.add(RequestMethod.POST, "/messages/remove-by-metadata", new RemoveMessageServeEventsByMetadataTask());
        router.add(RequestMethod.POST, "/messages/wait", new WaitForMessageEventTask());
        router.add(RequestMethod.POST, "/messages/wait-for-count", new WaitForMessageEventsTask());
        router.add(RequestMethod.GET, "/messages/{id}", new GetMessageServeEventTask());
        router.add(RequestMethod.DELETE, "/messages/{id}", new RemoveMessageServeEventTask());
        router.add(RequestMethod.GET, "/message-mappings", new GetAllMessageStubMappingsTask());
        router.add(RequestMethod.POST, "/message-mappings", new CreateMessageStubMappingTask());
        router.add(RequestMethod.DELETE, "/message-mappings", new ResetMessageStubMappingsTask());
        router.add(RequestMethod.DELETE, "/message-mappings/{id}", new RemoveMessageStubMappingTask());
        router.add(RequestMethod.POST, "/message-mappings/find-by-metadata", new FindMessageStubMappingsByMetadataTask());
        router.add(RequestMethod.POST, "/message-mappings/remove-by-metadata", new RemoveMessageStubMappingsByMetadataTask());
    }

    protected void initAdditionalRoutes(Router routeBuilder) {
        for (AdminApiExtension apiExtension : this.apiExtensions) {
            apiExtension.contributeAdminApiRoutes(routeBuilder);
        }
    }

    public AdminTask taskFor(RequestMethod method, String path) {
        return this.routes.entrySet().stream().filter(entry -> ((RequestSpec)entry.getKey()).matches(method, path)).map(Map.Entry::getValue).findFirst().orElseGet(NotFoundAdminTask::new);
    }

    public RequestSpec requestSpecForTask(Class<? extends AdminTask> taskClass) {
        return this.routes.entrySet().stream().filter(input -> ((AdminTask)input.getValue()).getClass().equals(taskClass)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new NotFoundException("No route could be found for " + taskClass.getSimpleName()));
    }

    protected static class RouteBuilder
    implements Router {
        private final ImmutableBiMap.Builder<RequestSpec, AdminTask> builder = ImmutableBiMap.builder();

        @Override
        public void add(RequestMethod method, String urlTemplate, Class<? extends AdminTask> taskClass) {
            try {
                AdminTask task = taskClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.add(RequestSpec.requestSpec(method, urlTemplate), task);
            }
            catch (Exception e) {
                Exceptions.throwUnchecked(e);
            }
        }

        @Override
        public void add(RequestMethod method, String urlTemplate, AdminTask task) {
            this.add(RequestSpec.requestSpec(method, urlTemplate), task);
        }

        public void add(RequestSpec requestSpec, AdminTask task) {
            this.builder.put((Object)requestSpec, (Object)task);
        }

        ImmutableBiMap<RequestSpec, AdminTask> build() {
            return this.builder.build();
        }
    }
}

