/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.filemaker.FilenameMaker;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;

class SnapshotStubMappingBodyExtractor {
    private final BlobStore filesBlobStore;

    SnapshotStubMappingBodyExtractor(BlobStore filesBlobStore) {
        this.filesBlobStore = filesBlobStore;
    }

    StubMapping extractInPlace(StubMapping stubMapping) {
        byte[] body = stubMapping.getResponse().getByteBody();
        HttpHeaders responseHeaders = stubMapping.getResponse().getHeaders();
        String extension = ContentTypes.determineFileExtension(ParameterUtils.getFirstNonNull(stubMapping.getRequest().getUrl(), stubMapping.getRequest().getUrlPath()), responseHeaders.getContentTypeHeader(), body);
        FilenameMaker filenameMaker = new FilenameMaker("default", extension);
        String bodyFileName = filenameMaker.filenameFor(stubMapping);
        this.filesBlobStore.put(bodyFileName, body);
        String noStringBody = null;
        byte[] noByteBody = null;
        return stubMapping.transform(sm -> sm.setResponse(ResponseDefinitionBuilder.like(stubMapping.getResponse()).withBodyFile(bodyFileName).withBody(noStringBody).withBody(noByteBody).withBase64Body(null).build()));
    }
}

