/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePatternBuilder;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;

public class RequestPatternBuilder {
    private final RequestPattern.Builder builder;

    public RequestPatternBuilder() {
        this(new RequestPattern.Builder());
    }

    public RequestPatternBuilder(ValueMatcher<Request> customMatcher) {
        this();
        this.builder.setInlineCustomMatcher(customMatcher);
    }

    public RequestPatternBuilder(RequestMethod method, UrlPattern url) {
        this();
        this.builder.setMethod(method);
        this.builder.setUrl(url);
    }

    public RequestPatternBuilder(String customRequestMatcherName, Parameters parameters) {
        this();
        this.builder.setCustomMatcherDefinition(new CustomMatcherDefinition(customRequestMatcherName, parameters));
    }

    private RequestPatternBuilder(RequestPattern.Builder builder) {
        this.builder = builder;
    }

    public static RequestPatternBuilder newRequestPattern(RequestMethod method, UrlPattern url) {
        return new RequestPatternBuilder(method, url);
    }

    public static RequestPatternBuilder newRequestPattern() {
        return new RequestPatternBuilder();
    }

    public static RequestPatternBuilder forCustomMatcher(ValueMatcher<Request> requestMatcher) {
        return new RequestPatternBuilder(requestMatcher);
    }

    public static RequestPatternBuilder forCustomMatcher(String customRequestMatcherName, Parameters parameters) {
        return new RequestPatternBuilder(customRequestMatcherName, parameters);
    }

    public static RequestPatternBuilder allRequests() {
        return new RequestPatternBuilder(RequestMethod.ANY, WireMock.anyUrl());
    }

    @Deprecated
    public static RequestPatternBuilder like(RequestPattern requestPattern) {
        return new RequestPatternBuilder(requestPattern.toBuilder());
    }

    @Deprecated
    public RequestPatternBuilder but() {
        return this;
    }

    public RequestPatternBuilder withScheme(String scheme) {
        this.builder.setScheme(scheme);
        return this;
    }

    public RequestPatternBuilder withHost(StringValuePattern hostPattern) {
        this.builder.setHost(hostPattern);
        return this;
    }

    public RequestPatternBuilder withPort(int port) {
        this.builder.setPort(port);
        return this;
    }

    public RequestPatternBuilder withClientIp(StringValuePattern clientIpPattern) {
        this.builder.setClientIp(clientIpPattern);
        return this;
    }

    public RequestPatternBuilder withUrl(String url) {
        this.builder.setUrl(WireMock.urlEqualTo(url));
        return this;
    }

    public RequestPatternBuilder withUrl(UrlPattern urlPattern) {
        this.builder.setUrl(urlPattern);
        return this;
    }

    public RequestPatternBuilder withHeader(String key, StringValuePattern valuePattern) {
        this.builder.getHeaders().put(key, MultiValuePattern.of(valuePattern));
        return this;
    }

    public RequestPatternBuilder withHeader(String key, MultiValuePattern multiValuePattern) {
        this.builder.getHeaders().put(key, multiValuePattern);
        return this;
    }

    public RequestPatternBuilder withoutHeader(String key) {
        this.builder.getHeaders().put(key, MultiValuePattern.absent());
        return this;
    }

    public RequestPatternBuilder withPathParam(String key, StringValuePattern valuePattern) {
        this.builder.getPathParams().put(key, valuePattern);
        return this;
    }

    public RequestPatternBuilder withQueryParam(String key, StringValuePattern valuePattern) {
        this.builder.getQueryParams().put(key, MultiValuePattern.of(valuePattern));
        return this;
    }

    public RequestPatternBuilder withQueryParam(String key, MultiValuePattern multiValuePattern) {
        this.builder.getQueryParams().put(key, multiValuePattern);
        return this;
    }

    public RequestPatternBuilder withFormParam(String key, StringValuePattern valuePattern) {
        this.builder.getFormParams().put(key, MultiValuePattern.of(valuePattern));
        return this;
    }

    public RequestPatternBuilder withFormParam(String key, MultiValuePattern multiValuePattern) {
        this.builder.getFormParams().put(key, multiValuePattern);
        return this;
    }

    public RequestPatternBuilder withoutFormParam(String key) {
        this.builder.getFormParams().put(key, MultiValuePattern.absent());
        return this;
    }

    public RequestPatternBuilder withoutQueryParam(String key) {
        this.builder.getQueryParams().put(key, MultiValuePattern.absent());
        return this;
    }

    public RequestPatternBuilder withCookie(String key, StringValuePattern valuePattern) {
        this.builder.getCookies().put(key, valuePattern);
        return this;
    }

    public RequestPatternBuilder withBasicAuth(BasicCredentials basicCredentials) {
        this.builder.setBasicAuthCredentials(basicCredentials);
        return this;
    }

    public RequestPatternBuilder withRequestBody(ContentPattern valuePattern) {
        this.builder.getBodyPatterns().add(valuePattern);
        return this;
    }

    public RequestPatternBuilder withRequestBodyPart(MultipartValuePattern multiPattern) {
        if (multiPattern != null) {
            this.builder.getMultipartPatterns().add(multiPattern);
        }
        return this;
    }

    public RequestPatternBuilder withAnyRequestBodyPart(MultipartValuePatternBuilder multiPatternBuilder) {
        return this.withRequestBodyPart(multiPatternBuilder.matchingType(MultipartValuePattern.MatchingType.ANY).build());
    }

    public RequestPatternBuilder withAllRequestBodyParts(MultipartValuePatternBuilder multiPatternBuilder) {
        return this.withRequestBodyPart(multiPatternBuilder.matchingType(MultipartValuePattern.MatchingType.ALL).build());
    }

    public RequestPatternBuilder andMatching(ValueMatcher<Request> customMatcher) {
        this.builder.setInlineCustomMatcher(customMatcher);
        return this;
    }

    public RequestPatternBuilder andMatching(String customRequestMatcherName) {
        return this.andMatching(customRequestMatcherName, Parameters.empty());
    }

    public RequestPatternBuilder andMatching(String customRequestMatcherName, Parameters parameters) {
        return this.andMatching(new CustomMatcherDefinition(customRequestMatcherName, parameters));
    }

    public RequestPatternBuilder andMatching(CustomMatcherDefinition matcherDefinition) {
        this.builder.setCustomMatcherDefinition(matcherDefinition);
        return this;
    }

    public RequestPatternBuilder clearQueryParams() {
        this.builder.getQueryParams().clear();
        return this;
    }

    public RequestPatternBuilder clearFormParams() {
        this.builder.getFormParams().clear();
        return this;
    }

    public RequestPatternBuilder clearBodyPatterns() {
        this.builder.getBodyPatterns().clear();
        return this;
    }

    public RequestPattern build() {
        return this.builder.build();
    }
}

