/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.RequestPathParamsDecorator;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.CustomMatcherDefinition;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MemoizingMatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcher;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPathTemplatePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.matching.WeightedMatchResult;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RequestPattern
implements NamedValueMatcher<Request> {
    private final String scheme;
    private final StringValuePattern host;
    private final Integer port;
    private final StringValuePattern clientIp;
    private final UrlPattern url;
    private final RequestMethod method;
    private final @NonNull Map<String, MultiValuePattern> headers;
    private final @NonNull Map<String, StringValuePattern> pathParams;
    private final @NonNull Map<String, MultiValuePattern> queryParams;
    private final @NonNull Map<String, MultiValuePattern> formParams;
    private final @NonNull Map<String, StringValuePattern> cookies;
    private final BasicCredentials basicAuthCredentials;
    private final @NonNull List<ContentPattern<?>> bodyPatterns;
    private final @NonNull List<MultipartValuePattern> multipartPatterns;
    private final CustomMatcherDefinition customMatcherDefinition;
    private final ValueMatcher<Request> matcher;
    private final ValueMatcher<Request> inlineCustomMatcher;
    public static final RequestPattern ANYTHING = RequestPatternBuilder.newRequestPattern(RequestMethod.ANY, WireMock.anyUrl()).build();

    @JsonCreator
    public RequestPattern(@JsonProperty(value="scheme") String scheme, @JsonProperty(value="host") StringValuePattern host, @JsonProperty(value="port") Integer port, @JsonProperty(value="url") String url, @JsonProperty(value="clientIp") StringValuePattern clientIp, @JsonProperty(value="urlPattern") String urlPattern, @JsonProperty(value="urlPath") String urlPath, @JsonProperty(value="urlPathPattern") String urlPathPattern, @JsonProperty(value="urlPathTemplate") String urlPathTemplate, @JsonProperty(value="method") RequestMethod method, @JsonProperty(value="headers") Map<String, MultiValuePattern> headers, @JsonProperty(value="pathParameters") Map<String, StringValuePattern> pathParams, @JsonProperty(value="queryParameters") Map<String, MultiValuePattern> queryParams, @JsonProperty(value="formParameters") Map<String, MultiValuePattern> formParams, @JsonProperty(value="cookies") Map<String, StringValuePattern> cookies, @JsonProperty(value="basicAuth") BasicCredentials basicAuthCredentials, @JsonProperty(value="bodyPatterns") List<ContentPattern<?>> bodyPatterns, @JsonProperty(value="customMatcher") CustomMatcherDefinition customMatcherDefinition, @JsonProperty(value="multipartPatterns") List<MultipartValuePattern> multiPattern) {
        this(scheme, host, port, clientIp, UrlPattern.fromOneOf(url, urlPattern, urlPath, urlPathPattern, urlPathTemplate), method, headers, pathParams, queryParams, formParams, cookies, basicAuthCredentials, bodyPatterns, customMatcherDefinition, null, multiPattern);
    }

    RequestPattern(String scheme, StringValuePattern host, Integer port, StringValuePattern clientIp, UrlPattern url, RequestMethod method, Map<String, MultiValuePattern> headers, Map<String, StringValuePattern> pathParams, Map<String, MultiValuePattern> queryParams, Map<String, MultiValuePattern> formParams, Map<String, StringValuePattern> cookies, BasicCredentials basicAuthCredentials, List<ContentPattern<?>> bodyPatterns, CustomMatcherDefinition customMatcherDefinition, final ValueMatcher<Request> customMatcher, List<MultipartValuePattern> multiPattern) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.clientIp = clientIp;
        this.url = ParameterUtils.getFirstNonNull(url, UrlPattern.ANY);
        this.method = ParameterUtils.getFirstNonNull(method, RequestMethod.ANY);
        this.headers = headers != null ? ImmutableMap.copyOf(headers) : Map.of();
        this.pathParams = pathParams != null ? ImmutableMap.copyOf(pathParams) : Map.of();
        this.formParams = formParams != null ? ImmutableMap.copyOf(formParams) : Map.of();
        this.queryParams = queryParams != null ? ImmutableMap.copyOf(queryParams) : Map.of();
        this.cookies = cookies != null ? ImmutableMap.copyOf(cookies) : Map.of();
        this.basicAuthCredentials = basicAuthCredentials;
        this.bodyPatterns = bodyPatterns != null ? List.copyOf(bodyPatterns) : List.of();
        this.customMatcherDefinition = customMatcherDefinition;
        this.multipartPatterns = multiPattern != null ? List.copyOf(multiPattern) : List.of();
        this.inlineCustomMatcher = customMatcher;
        this.matcher = new RequestMatcher(){

            @Override
            public MatchResult match(Request request) {
                ArrayList<WeightedMatchResult> requestPartMatchResults = new ArrayList<WeightedMatchResult>(15);
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.schemeMatches(request), 3.0));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.hostMatches(request), 10.0));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.portMatches(request), 10.0));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.clientIpMatches(request), 3.0));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.url.match(request.getUrl()), 10.0));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.method.match(request.getMethod()), 3.0));
                MemoizingMatchResult matchResult = new MemoizingMatchResult(MatchResult.aggregateWeighted(requestPartMatchResults));
                if (!((MatchResult)matchResult).isExactMatch()) {
                    return matchResult;
                }
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.allPathParamsMatch(request)));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.allHeadersMatchResult(request)));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.allQueryParamsMatch(request)));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.allFormParamsMatch(request)));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.allCookiesMatch(request)));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.allBodyPatternsMatch(request)));
                requestPartMatchResults.add(WeightedMatchResult.weight(RequestPattern.this.allMultipartPatternsMatch(request)));
                matchResult = new MemoizingMatchResult(MatchResult.aggregateWeighted(requestPartMatchResults));
                if (!((MatchResult)matchResult).isExactMatch() || customMatcher == null) {
                    return matchResult;
                }
                requestPartMatchResults.add(WeightedMatchResult.weight(customMatcher.match(request)));
                return new MemoizingMatchResult(MatchResult.aggregateWeighted(requestPartMatchResults));
            }

            @Override
            public String getName() {
                return "request-matcher";
            }
        };
    }

    public RequestPattern transform(Consumer<Builder> transformer) {
        Builder builder = this.toBuilder();
        transformer.accept(builder);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public MatchResult match(Request request) {
        return this.match(request, Collections.emptyMap());
    }

    public MatchResult match(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        MatchResult standardMatchResult = this.matcher.match(request = RequestPathParamsDecorator.decorate(request, this));
        if (standardMatchResult.isExactMatch() && this.customMatcherDefinition != null) {
            RequestMatcherExtension requestMatcher = ParameterUtils.getFirstNonNull(customMatchers.get(this.customMatcherDefinition.getName()), RequestMatcherExtension.NEVER);
            MatchResult customMatchResult = requestMatcher.match(request, this.customMatcherDefinition.getParameters());
            return MatchResult.aggregate(standardMatchResult, customMatchResult);
        }
        return standardMatchResult;
    }

    private MatchResult allCookiesMatch(Request request) {
        if (!this.cookies.isEmpty()) {
            return MatchResult.aggregate(this.cookies.entrySet().stream().map(entry -> {
                StringValuePattern cookiePattern = (StringValuePattern)entry.getValue();
                Cookie cookie = request.getCookies().get(entry.getKey());
                if (cookie == null) {
                    return cookiePattern.nullSafeIsAbsent() ? MatchResult.exactMatch(new SubEvent[0]) : MatchResult.noMatch(new SubEvent[0]);
                }
                return cookie.getValues().stream().map(cookiePattern::match).max(Comparator.naturalOrder()).orElseGet(() -> MatchResult.noMatch(new SubEvent[0]));
            }).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult schemeMatches(Request request) {
        return this.scheme != null ? MatchResult.of(this.scheme.equals(request.getScheme()), new SubEvent[0]) : MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult hostMatches(Request request) {
        return this.host != null ? this.host.match(request.getHost()) : MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult portMatches(Request request) {
        return this.port != null ? MatchResult.of(request.getPort() == this.port.intValue(), new SubEvent[0]) : MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult clientIpMatches(Request request) {
        return this.clientIp != null ? this.clientIp.match(request.getClientIp()) : MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allHeadersMatchResult(Request request) {
        Map<String, MultiValuePattern> combinedHeaders = this.combineBasicAuthAndOtherHeaders();
        if (combinedHeaders != null && !combinedHeaders.isEmpty()) {
            return MatchResult.aggregate(combinedHeaders.entrySet().stream().map(headerPattern -> ((MultiValuePattern)headerPattern.getValue()).match(request.header((String)headerPattern.getKey()))).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    public Map<String, MultiValuePattern> combineBasicAuthAndOtherHeaders() {
        if (this.basicAuthCredentials == null) {
            return this.headers;
        }
        Map<String, MultiValuePattern> combinedHeaders = this.headers;
        HashMap<String, MultiValuePattern> allHeadersBuilder = new HashMap<String, MultiValuePattern>(ParameterUtils.getFirstNonNull(combinedHeaders, Collections.emptyMap()));
        allHeadersBuilder.put("Authorization", this.basicAuthCredentials.asAuthorizationMultiValuePattern());
        combinedHeaders = allHeadersBuilder;
        return combinedHeaders;
    }

    private MatchResult allQueryParamsMatch(Request request) {
        if (!this.queryParams.isEmpty()) {
            return MatchResult.aggregate(this.queryParams.entrySet().stream().map(queryParamPattern -> ((MultiValuePattern)queryParamPattern.getValue()).match(request.queryParameter((String)queryParamPattern.getKey()))).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allFormParamsMatch(Request request) {
        if (!this.formParams.isEmpty()) {
            return MatchResult.aggregate(this.formParams.entrySet().stream().map(formParamPattern -> ((MultiValuePattern)formParamPattern.getValue()).match(request.formParameter((String)formParamPattern.getKey()))).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allPathParamsMatch(Request request) {
        if (this.url.getClass().equals(UrlPathTemplatePattern.class) && !this.pathParams.isEmpty()) {
            UrlPathTemplatePattern urlPathTemplatePattern = (UrlPathTemplatePattern)this.url;
            PathTemplate pathTemplate = urlPathTemplatePattern.getPathTemplate();
            if (!pathTemplate.matches(request.getUrl())) {
                return MatchResult.noMatch(new SubEvent[0]);
            }
            PathParams requestPathParams = pathTemplate.parse(Urls.getPath(request.getUrl()));
            return MatchResult.aggregate(this.pathParams.entrySet().stream().map(entry -> ((StringValuePattern)entry.getValue()).match((String)requestPathParams.get(entry.getKey()))).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allBodyPatternsMatch(Request request) {
        if (!this.bodyPatterns.isEmpty() && request.getBody() != null) {
            return MatchResult.aggregate(this.bodyPatterns.stream().map(pattern -> {
                if (StringValuePattern.class.isAssignableFrom(pattern.getClass())) {
                    String body = Strings.isEmpty(request.getBodyAsString()) ? null : request.getBodyAsString();
                    return pattern.match(body);
                }
                return pattern.match(request.getBody());
            }).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    private MatchResult allMultipartPatternsMatch(Request request) {
        if (!this.multipartPatterns.isEmpty()) {
            if (!request.isMultipart()) {
                return MatchResult.noMatch(new SubEvent[0]);
            }
            return MatchResult.aggregate(this.multipartPatterns.stream().map(pattern -> pattern.match(request)).collect(Collectors.toList()));
        }
        return MatchResult.exactMatch(new SubEvent[0]);
    }

    public boolean isMatchedBy(Request request, Map<String, RequestMatcherExtension> customMatchers) {
        return this.match(request, customMatchers).isExactMatch();
    }

    public String getScheme() {
        return this.scheme;
    }

    public StringValuePattern getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public StringValuePattern getClientIp() {
        return this.clientIp;
    }

    public String getUrl() {
        return this.urlPatternOrNull(UrlPattern.class, false);
    }

    public String getUrlPattern() {
        return this.urlPatternOrNull(UrlPattern.class, true);
    }

    public String getUrlPath() {
        return this.urlPatternOrNull(UrlPathPattern.class, false);
    }

    public String getUrlPathPattern() {
        return this.urlPatternOrNull(UrlPathPattern.class, true);
    }

    public String getUrlPathTemplate() {
        return this.urlPatternOrNull(UrlPathTemplatePattern.class, false);
    }

    @JsonIgnore
    public UrlPattern getUrlMatcher() {
        return this.url;
    }

    private String urlPatternOrNull(Class<? extends UrlPattern> clazz, boolean regex) {
        return this.url != null && this.url.getClass().equals(clazz) && this.url.isRegex() == regex && this.url.isSpecified() ? (String)this.url.getPattern().getValue() : null;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull Map<String, MultiValuePattern> getHeaders() {
        return this.headers;
    }

    public BasicCredentials getBasicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull Map<String, StringValuePattern> getPathParameters() {
        return this.pathParams;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull Map<String, MultiValuePattern> getQueryParameters() {
        return this.queryParams;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull Map<String, MultiValuePattern> getFormParameters() {
        return this.formParams;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull Map<String, StringValuePattern> getCookies() {
        return this.cookies;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull List<ContentPattern<?>> getBodyPatterns() {
        return this.bodyPatterns;
    }

    public CustomMatcherDefinition getCustomMatcher() {
        return this.customMatcherDefinition;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public @NonNull List<MultipartValuePattern> getMultipartPatterns() {
        return this.multipartPatterns;
    }

    @JsonIgnore
    public ValueMatcher<Request> getInlineCustomMatcher() {
        return this.inlineCustomMatcher;
    }

    @Override
    public String getName() {
        return "requestMatching";
    }

    @Override
    public String getExpected() {
        return this.toString();
    }

    public boolean hasInlineCustomMatcher() {
        return this.inlineCustomMatcher != null;
    }

    public boolean hasNamedCustomMatcher() {
        return this.customMatcherDefinition != null;
    }

    public boolean hasCustomMatcher() {
        return this.hasInlineCustomMatcher() || this.hasNamedCustomMatcher();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestPattern that = (RequestPattern)o;
        return Objects.equals(this.scheme, that.scheme) && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.clientIp, that.clientIp) && Objects.equals(this.url, that.url) && Objects.equals(this.method, that.method) && Objects.equals(this.headers, that.headers) && Objects.equals(this.pathParams, that.pathParams) && Objects.equals(this.queryParams, that.queryParams) && Objects.equals(this.formParams, that.formParams) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.basicAuthCredentials, that.basicAuthCredentials) && Objects.equals(this.bodyPatterns, that.bodyPatterns) && Objects.equals(this.multipartPatterns, that.multipartPatterns) && Objects.equals(this.customMatcherDefinition, that.customMatcherDefinition) && Objects.equals(this.inlineCustomMatcher, that.inlineCustomMatcher);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.host, this.port, this.clientIp, this.url, this.method, this.headers, this.pathParams, this.queryParams, this.formParams, this.cookies, this.basicAuthCredentials, this.bodyPatterns, this.multipartPatterns, this.customMatcherDefinition, this.inlineCustomMatcher);
    }

    public String toString() {
        return Json.write(this);
    }

    public static Predicate<Request> thatMatch(RequestPattern pattern) {
        return RequestPattern.thatMatch(pattern, Collections.emptyMap());
    }

    public static Predicate<Request> thatMatch(RequestPattern pattern, Map<String, RequestMatcherExtension> customMatchers) {
        return request -> pattern.match((Request)request, customMatchers).isExactMatch();
    }

    public static Predicate<ServeEvent> withRequestMatching(RequestPattern pattern) {
        return serveEvent -> pattern.match(serveEvent.getRequest()).isExactMatch();
    }

    public static Predicate<ServeEvent> withRequestMatching(RequestPattern pattern, Map<String, RequestMatcherExtension> customMatchers) {
        return serveEvent -> pattern.match(serveEvent.getRequest(), customMatchers).isExactMatch();
    }

    public static class Builder {
        private String scheme;
        private StringValuePattern host;
        private Integer port;
        private StringValuePattern clientIp;
        private UrlPattern url;
        private RequestMethod method;
        private @NonNull Map<String, MultiValuePattern> headers = new LinkedHashMap<String, MultiValuePattern>();
        private @NonNull Map<String, StringValuePattern> pathParams = new LinkedHashMap<String, StringValuePattern>();
        private @NonNull Map<String, MultiValuePattern> queryParams = new LinkedHashMap<String, MultiValuePattern>();
        private @NonNull Map<String, MultiValuePattern> formParams = new LinkedHashMap<String, MultiValuePattern>();
        private @NonNull Map<String, StringValuePattern> cookies = new LinkedHashMap<String, StringValuePattern>();
        private BasicCredentials basicAuthCredentials;
        private @NonNull List<ContentPattern<?>> bodyPatterns = new ArrayList();
        private @NonNull List<MultipartValuePattern> multipartPatterns = new ArrayList<MultipartValuePattern>();
        private CustomMatcherDefinition customMatcherDefinition;
        private ValueMatcher<Request> inlineCustomMatcher;

        public Builder() {
        }

        public Builder(RequestPattern existing) {
            this.scheme = existing.getScheme();
            this.host = existing.getHost();
            this.port = existing.getPort();
            this.clientIp = existing.getClientIp();
            this.url = existing.getUrlMatcher();
            this.method = existing.getMethod();
            this.headers.putAll(existing.getHeaders());
            this.pathParams.putAll(existing.getPathParameters());
            this.queryParams.putAll(existing.getQueryParameters());
            this.formParams.putAll(existing.getFormParameters());
            this.cookies.putAll(existing.getCookies());
            this.basicAuthCredentials = existing.getBasicAuthCredentials();
            this.bodyPatterns.addAll(existing.getBodyPatterns());
            this.multipartPatterns.addAll(existing.getMultipartPatterns());
            this.customMatcherDefinition = existing.getCustomMatcher();
            this.inlineCustomMatcher = existing.getInlineCustomMatcher();
        }

        public String getScheme() {
            return this.scheme;
        }

        public StringValuePattern getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public StringValuePattern getClientIp() {
            return this.clientIp;
        }

        public UrlPattern getUrl() {
            return this.url;
        }

        public RequestMethod getMethod() {
            return this.method;
        }

        public @NonNull Map<String, MultiValuePattern> getHeaders() {
            return this.headers;
        }

        public @NonNull Map<String, StringValuePattern> getPathParams() {
            return this.pathParams;
        }

        public @NonNull Map<String, MultiValuePattern> getQueryParams() {
            return this.queryParams;
        }

        public @NonNull Map<String, MultiValuePattern> getFormParams() {
            return this.formParams;
        }

        public @NonNull Map<String, StringValuePattern> getCookies() {
            return this.cookies;
        }

        public BasicCredentials getBasicAuthCredentials() {
            return this.basicAuthCredentials;
        }

        public @NonNull List<ContentPattern<?>> getBodyPatterns() {
            return this.bodyPatterns;
        }

        public @NonNull List<MultipartValuePattern> getMultipartPatterns() {
            return this.multipartPatterns;
        }

        public CustomMatcherDefinition getCustomMatcherDefinition() {
            return this.customMatcherDefinition;
        }

        public ValueMatcher<Request> getInlineCustomMatcher() {
            return this.inlineCustomMatcher;
        }

        public Builder setScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder setHost(StringValuePattern host) {
            this.host = host;
            return this;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder setClientIp(StringValuePattern clientIp) {
            this.clientIp = clientIp;
            return this;
        }

        public Builder setUrl(UrlPattern url) {
            this.url = url;
            return this;
        }

        public Builder setMethod(RequestMethod method) {
            this.method = method;
            return this;
        }

        public Builder setHeaders(@NonNull Map<String, MultiValuePattern> headers) {
            Objects.requireNonNull(headers);
            this.headers = headers;
            return this;
        }

        public Builder setPathParams(@NonNull Map<String, StringValuePattern> pathParams) {
            Objects.requireNonNull(pathParams);
            this.pathParams = pathParams;
            return this;
        }

        public Builder setQueryParams(@NonNull Map<String, MultiValuePattern> queryParams) {
            Objects.requireNonNull(queryParams);
            this.queryParams = queryParams;
            return this;
        }

        public Builder setFormParams(@NonNull Map<String, MultiValuePattern> formParams) {
            Objects.requireNonNull(formParams);
            this.formParams = formParams;
            return this;
        }

        public Builder setCookies(@NonNull Map<String, StringValuePattern> cookies) {
            Objects.requireNonNull(cookies);
            this.cookies = cookies;
            return this;
        }

        public Builder setBasicAuthCredentials(BasicCredentials basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public Builder setBodyPatterns(@NonNull List<ContentPattern<?>> bodyPatterns) {
            Objects.requireNonNull(bodyPatterns);
            this.bodyPatterns = bodyPatterns;
            return this;
        }

        public Builder setMultipartPatterns(@NonNull List<MultipartValuePattern> multipartPatterns) {
            Objects.requireNonNull(multipartPatterns);
            this.multipartPatterns = multipartPatterns;
            return this;
        }

        public Builder setCustomMatcherDefinition(CustomMatcherDefinition customMatcherDefinition) {
            this.customMatcherDefinition = customMatcherDefinition;
            return this;
        }

        public Builder setInlineCustomMatcher(ValueMatcher<Request> matcher) {
            this.inlineCustomMatcher = matcher;
            return this;
        }

        public RequestPattern build() {
            if (!(this.url instanceof UrlPathTemplatePattern) && !this.pathParams.isEmpty()) {
                throw new InvalidInputException(Errors.single(19, "URL path parameters specified without a path template as the URL matcher"));
            }
            return new RequestPattern(this.scheme, this.host, this.port, this.clientIp, this.url, this.method, this.headers, this.pathParams, this.queryParams, this.formParams, this.cookies, this.basicAuthCredentials, this.bodyPatterns, this.customMatcherDefinition, this.inlineCustomMatcher, this.multipartPatterns);
        }
    }
}

