/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class Metadata
implements Map<String, Object> {
    private final Map<String, Object> data;

    public Metadata() {
        this.data = Collections.emptyMap();
    }

    @JsonCreator
    public Metadata(Map<? extends String, ?> data) {
        this.data = Collections.unmodifiableMap(this.convertNestedMapsToMetadata(data));
    }

    protected Map<String, Object> convertNestedMapsToMetadata(Map<? extends String, ?> data) {
        if (data == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map && !this.getClass().isInstance(value)) {
                result.put(entry.getKey(), this.newInstance((Map)value));
                continue;
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    protected Metadata newInstance(Map<String, Object> value) {
        return new Metadata(value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Metadata create(Consumer<Builder> transformer) {
        Builder builder = Metadata.builder();
        transformer.accept(builder);
        return builder.build();
    }

    public Metadata transform(Consumer<Builder> transformer) {
        Builder builder = this.toBuilder();
        transformer.accept(builder);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getInt(String key) {
        return this.checkPresenceValidityAndCast(key, Integer.class);
    }

    public Integer getInt(String key, Integer defaultValue) {
        return this.returnIfValidOrDefaultIfNot(key, Integer.class, defaultValue);
    }

    public Boolean getBoolean(String key) {
        return this.checkPresenceValidityAndCast(key, Boolean.class);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.returnIfValidOrDefaultIfNot(key, Boolean.class, defaultValue);
    }

    public String getString(String key) {
        return this.checkPresenceValidityAndCast(key, String.class);
    }

    public String getString(String key, String defaultValue) {
        return this.returnIfValidOrDefaultIfNot(key, String.class, defaultValue);
    }

    public List<?> getList(String key) {
        return this.checkPresenceValidityAndCast(key, List.class);
    }

    public Metadata getMetadata(String key) {
        this.checkKeyPresent(key);
        ParameterUtils.checkParameter(Map.class.isAssignableFrom(this.get(key).getClass()), key + " is not a map");
        return new Metadata((Map)this.get(key));
    }

    public Metadata getMetadata(String key, Metadata defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        ParameterUtils.checkParameter(Map.class.isAssignableFrom(this.get(key).getClass()), key + " is not a map");
        return new Metadata((Map)this.get(key));
    }

    private <T> T checkPresenceValidityAndCast(String key, Class<T> type) {
        this.checkKeyPresent(key);
        ParameterUtils.checkParameter(type.isAssignableFrom(this.get(key).getClass()), key + " is not of type " + type.getSimpleName());
        return (T)this.get(key);
    }

    private <T> T returnIfValidOrDefaultIfNot(String key, Class<T> type, T defaultValue) {
        if (!this.containsKey(key) || !type.isAssignableFrom(this.get(key).getClass())) {
            return defaultValue;
        }
        return (T)this.get(key);
    }

    protected void checkKeyPresent(String key) {
        ParameterUtils.checkParameter(this.containsKey(key), key + "' not present");
    }

    public static <T> Metadata from(T myData) {
        return new Metadata(Json.objectToMap(myData));
    }

    public static Builder metadata() {
        return new Builder();
    }

    public <T> T as(Class<T> myDataClass) {
        return Json.mapToObject(this, myDataClass);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.data.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.data.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.data.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.data.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.data.forEach(action);
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public Object replace(String key, Object value) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        throw new UnsupportedOperationException("Metadata is immutable");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return this.data.equals(metadata.data);
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }

    public String toString() {
        return new StringJoiner(", ", Metadata.class.getSimpleName() + "[", "]").add("data=" + String.valueOf(this.data)).toString();
    }

    public Metadata deepMerge(Metadata toMerge) {
        return this.transform(builder -> {
            for (Map.Entry<String, Object> entry : toMerge.entrySet()) {
                Object existing;
                if (entry.getValue() instanceof Metadata) {
                    existing = this.get(entry.getKey());
                    if (existing instanceof Metadata) {
                        builder.attr(entry.getKey(), ((Metadata)existing).deepMerge((Metadata)entry.getValue()));
                        continue;
                    }
                    builder.attr(entry.getKey(), entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    existing = this.get(entry.getKey());
                    if (existing instanceof List) {
                        ArrayList merged = new ArrayList((List)existing);
                        merged.addAll((List)entry.getValue());
                        builder.attr(entry.getKey(), merged);
                        continue;
                    }
                    builder.attr(entry.getKey(), entry.getValue());
                    continue;
                }
                builder.attr(entry.getKey(), entry.getValue());
            }
        });
    }

    public Map<String, Object> asMutableMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.forEach((BiConsumer<? super String, ? super Object>)((BiConsumer<String, Object>)(key, value) -> {
            if (this.getClass().isInstance(value)) {
                map.put((String)key, ((Metadata)this.getClass().cast(value)).asMutableMap());
            } else {
                map.put((String)key, value);
            }
        }));
        return map;
    }

    public static class Builder {
        private final Map<String, Object> mapBuilder;

        public Builder() {
            this.mapBuilder = new LinkedHashMap<String, Object>();
        }

        public Builder(Metadata existing) {
            this.mapBuilder = new LinkedHashMap<String, Object>(existing.data);
        }

        public Builder attr(String key, Object value) {
            this.mapBuilder.put(key, value);
            return this;
        }

        public Builder attr(String key, Consumer<Builder> transformer) {
            Object existing = this.get(key);
            Builder builder = existing instanceof Metadata ? new Builder((Metadata)existing) : Metadata.builder();
            transformer.accept(builder);
            this.attr(key, builder);
            return this;
        }

        public Builder attr(String key, Builder metadataBuilder) {
            this.mapBuilder.put(key, metadataBuilder.build());
            return this;
        }

        public Builder list(String key, Object ... values) {
            this.mapBuilder.put(key, List.of(values));
            return this;
        }

        public Object get(String key) {
            return this.mapBuilder.get(key);
        }

        public boolean contains(String key) {
            return this.mapBuilder.containsKey(key);
        }

        public void remove(String key) {
            this.mapBuilder.remove(key);
        }

        public Metadata build() {
            return new Metadata(this.mapBuilder);
        }
    }
}

