/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.extension.PostServeActionDefinition;
import com.github.tomakehurst.wiremock.extension.PostServeActionDefinitionListDeserializer;
import com.github.tomakehurst.wiremock.extension.ServeEventListenerDefinition;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMappingOrMappings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

@JsonPropertyOrder(value={"id", "name", "request", "newRequest", "response"})
@JsonIgnoreProperties(value={"$schema", "uuid"})
public final class StubMapping
implements StubMappingOrMappings {
    public static final int DEFAULT_PRIORITY = 5;
    public static final StubMapping NOT_CONFIGURED = StubMapping.builder().setResponse(ResponseDefinition.notConfigured()).build();
    private final UUID id;
    private final String name;
    private final Boolean persistent;
    private final RequestPattern request;
    private final ResponseDefinition response;
    private final Integer priority;
    private final String scenarioName;
    private final String requiredScenarioState;
    private final String newScenarioState;
    private final List<PostServeActionDefinition> postServeActions;
    private final List<ServeEventListenerDefinition> serveEventListeners;
    private final Metadata metadata;
    private final long insertionIndex;

    @JsonCreator
    public StubMapping(@JsonProperty(value="id") UUID id, @JsonProperty(value="name") String name, @JsonProperty(value="persistent") Boolean persistent, @JsonProperty(value="request") RequestPattern request, @JsonProperty(value="response") ResponseDefinition response, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="scenarioName") String scenarioName, @JsonProperty(value="requiredScenarioState") String requiredScenarioState, @JsonProperty(value="newScenarioState") String newScenarioState, @JsonProperty(value="postServeActions") @JsonDeserialize(using=PostServeActionDefinitionListDeserializer.class) List<PostServeActionDefinition> postServeActions, @JsonProperty(value="serveEventListeners") List<ServeEventListenerDefinition> serveEventListeners, @JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="insertionIndex") @JsonView(value={Json.PrivateView.class}) long insertionIndex) {
        this.id = id != null ? id : UUID.randomUUID();
        this.name = name;
        this.persistent = persistent;
        this.request = ParameterUtils.getFirstNonNull(request, RequestPattern.ANYTHING);
        this.response = ParameterUtils.getFirstNonNull(response, ResponseDefinition.ok());
        this.priority = priority;
        this.scenarioName = scenarioName;
        this.requiredScenarioState = requiredScenarioState;
        this.newScenarioState = newScenarioState;
        this.postServeActions = postServeActions != null ? List.copyOf(postServeActions) : null;
        this.serveEventListeners = serveEventListeners != null ? List.copyOf(serveEventListeners) : null;
        this.metadata = metadata;
        this.insertionIndex = insertionIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StubMapping create(Consumer<Builder> transformer) {
        Builder builder = StubMapping.builder();
        transformer.accept(builder);
        return builder.build();
    }

    public StubMapping transform(Consumer<Builder> transformer) {
        Builder builder = this.toBuilder();
        transformer.accept(builder);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean isPersistent() {
        return this.persistent;
    }

    public RequestPattern getRequest() {
        return this.request;
    }

    public ResponseDefinition getResponse() {
        return this.response;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public String getRequiredScenarioState() {
        return this.requiredScenarioState;
    }

    public String getNewScenarioState() {
        return this.newScenarioState;
    }

    public List<PostServeActionDefinition> getPostServeActions() {
        return this.postServeActions;
    }

    public List<ServeEventListenerDefinition> getServeEventListeners() {
        return this.serveEventListeners;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public long getInsertionIndex() {
        return this.insertionIndex;
    }

    @JsonIgnore
    public boolean isInScenario() {
        return this.scenarioName != null;
    }

    @JsonIgnore
    public boolean modifiesScenarioState() {
        return this.newScenarioState != null;
    }

    @JsonIgnore
    public boolean isIndependentOfScenarioState() {
        return !this.isInScenario() || this.requiredScenarioState == null;
    }

    public int comparePriorityWith(StubMapping otherMapping) {
        int thisPriority = this.priority != null ? this.priority : 5;
        int otherPriority = otherMapping.priority != null ? otherMapping.priority : 5;
        return thisPriority - otherPriority;
    }

    public boolean shouldBePersisted() {
        return this.persistent != null && this.persistent != false;
    }

    @Override
    public List<StubMapping> getMappingOrMappings() {
        return List.of(this);
    }

    @Override
    public boolean isMulti() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StubMapping that = (StubMapping)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.priority, that.priority) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.scenarioName, that.scenarioName) && Objects.equals(this.request, that.request) && Objects.equals(this.newScenarioState, that.newScenarioState) && Objects.equals(this.response, that.response) && Objects.equals(this.requiredScenarioState, that.requiredScenarioState) && Objects.equals(this.postServeActions, that.postServeActions) && Objects.equals(this.serveEventListeners, that.serveEventListeners);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.request, this.response, this.priority, this.requiredScenarioState, this.newScenarioState, this.postServeActions, this.serveEventListeners, this.metadata);
    }

    public String toString() {
        return Json.write(this);
    }

    public static class Builder {
        private UUID id = UUID.randomUUID();
        private String name;
        private Boolean persistent;
        private RequestPattern request;
        private ResponseDefinition response;
        private Integer priority;
        private String scenarioName;
        private String requiredScenarioState;
        private String newScenarioState;
        private List<PostServeActionDefinition> postServeActions;
        private List<ServeEventListenerDefinition> serveEventListeners;
        private Metadata metadata;
        private long insertionIndex;

        public Builder() {
        }

        public Builder(StubMapping existing) {
            this.id = existing.id;
            this.name = existing.name;
            this.persistent = existing.persistent;
            this.request = existing.request;
            this.response = existing.response;
            this.priority = existing.priority;
            this.scenarioName = existing.scenarioName;
            this.requiredScenarioState = existing.requiredScenarioState;
            this.newScenarioState = existing.newScenarioState;
            this.postServeActions = existing.postServeActions != null ? new ArrayList<PostServeActionDefinition>(existing.postServeActions) : null;
            this.serveEventListeners = existing.serveEventListeners != null ? new ArrayList<ServeEventListenerDefinition>(existing.serveEventListeners) : null;
            this.metadata = existing.metadata;
            this.insertionIndex = existing.insertionIndex;
        }

        public StubMapping build() {
            return new StubMapping(this.id, this.name, this.persistent, this.request, this.response, this.priority, this.scenarioName, this.requiredScenarioState, this.newScenarioState, this.postServeActions, this.serveEventListeners, this.metadata, this.insertionIndex);
        }

        public UUID getId() {
            return this.id;
        }

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Boolean getPersistent() {
            return this.persistent;
        }

        public Builder setPersistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public RequestPattern getRequest() {
            return this.request;
        }

        public Builder setRequest(RequestPattern request) {
            this.request = request;
            return this;
        }

        public Builder request(Consumer<RequestPattern.Builder> transformer) {
            return this.setRequest(this.request.transform(transformer));
        }

        public ResponseDefinition getResponse() {
            return this.response;
        }

        public Builder setResponse(ResponseDefinition response) {
            this.response = response;
            return this;
        }

        public Builder response(Consumer<ResponseDefinition.Builder> transformer) {
            return this.setResponse(this.response.transform(transformer));
        }

        public Integer getPriority() {
            return this.priority;
        }

        public Builder setPriority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public String getScenarioName() {
            return this.scenarioName;
        }

        public Builder setScenarioName(String scenarioName) {
            this.scenarioName = scenarioName;
            return this;
        }

        public String getRequiredScenarioState() {
            return this.requiredScenarioState;
        }

        public Builder setRequiredScenarioState(String requiredScenarioState) {
            this.requiredScenarioState = requiredScenarioState;
            return this;
        }

        public String getNewScenarioState() {
            return this.newScenarioState;
        }

        public Builder setNewScenarioState(String newScenarioState) {
            this.newScenarioState = newScenarioState;
            return this;
        }

        public List<PostServeActionDefinition> getPostServeActions() {
            return this.postServeActions;
        }

        public Builder setPostServeActions(List<PostServeActionDefinition> postServeActions) {
            this.postServeActions = postServeActions;
            return this;
        }

        public List<ServeEventListenerDefinition> getServeEventListeners() {
            return this.serveEventListeners;
        }

        public Builder setServeEventListeners(List<ServeEventListenerDefinition> serveEventListeners) {
            this.serveEventListeners = serveEventListeners;
            return this;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public Builder setMetadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(Consumer<Metadata.Builder> transformer) {
            this.metadata = ParameterUtils.getFirstNonNull(this.metadata, new Metadata()).transform(transformer);
            return this;
        }

        public long getInsertionIndex() {
            return this.insertionIndex;
        }

        public Builder setInsertionIndex(long insertionIndex) {
            this.insertionIndex = insertionIndex;
            return this;
        }
    }
}

