/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.StubMappingTransformer;
import com.github.tomakehurst.wiremock.recording.StubGenerationResult;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.files.BlobStoreFileSource;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;
import java.util.function.Function;

class SnapshotStubMappingTransformerRunner
implements Function<Pair<ServeEvent, StubMapping>, StubGenerationResult> {
    private final FileSource filesRoot;
    private final Parameters parameters;
    private final Iterable<StubMappingTransformer> registeredTransformers;
    private final List<String> requestedTransformers;

    SnapshotStubMappingTransformerRunner(Iterable<StubMappingTransformer> registeredTransformers) {
        this(registeredTransformers, null, null, null);
    }

    SnapshotStubMappingTransformerRunner(Iterable<StubMappingTransformer> registeredTransformers, List<String> requestedTransformers, Parameters parameters, BlobStore filesBlobStore) {
        this.requestedTransformers = requestedTransformers;
        this.registeredTransformers = registeredTransformers;
        this.parameters = parameters;
        this.filesRoot = new BlobStoreFileSource(filesBlobStore);
    }

    @Override
    public StubGenerationResult apply(Pair<ServeEvent, StubMapping> serveEventToStubMapping) {
        StubMapping stubMapping = (StubMapping)serveEventToStubMapping.b;
        for (StubMappingTransformer transformer : this.registeredTransformers) {
            if (!transformer.applyGlobally() && (this.requestedTransformers == null || !this.requestedTransformers.contains(transformer.getName()))) continue;
            StubGenerationResult result = transformer.transform(stubMapping, this.filesRoot, this.parameters, (ServeEvent)serveEventToStubMapping.a);
            if (result instanceof StubGenerationResult.Success) {
                StubGenerationResult.Success success = (StubGenerationResult.Success)result;
                stubMapping = success.stubMapping();
                continue;
            }
            if (result instanceof StubGenerationResult.Failure) {
                StubGenerationResult.Failure failure = (StubGenerationResult.Failure)result;
                return failure;
            }
            throw new IllegalStateException("Unexpected result: " + String.valueOf(result));
        }
        return new StubGenerationResult.Success(stubMapping);
    }
}

