/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.filemaker.FilenameMaker;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.recording.CaptureHeadersSpec;
import com.github.tomakehurst.wiremock.recording.LoggedResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import com.github.tomakehurst.wiremock.recording.RequestPatternTransformer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;

class SnapshotStubMappingGenerator
implements Function<ServeEvent, StubMapping> {
    private final RequestPatternTransformer requestTransformer;
    private final LoggedResponseDefinitionTransformer responseTransformer;
    private final boolean markStubsPersistent;

    SnapshotStubMappingGenerator(RequestPatternTransformer requestTransformer, LoggedResponseDefinitionTransformer responseTransformer, boolean markStubsPersistent) {
        this.requestTransformer = requestTransformer;
        this.responseTransformer = responseTransformer;
        this.markStubsPersistent = markStubsPersistent;
    }

    SnapshotStubMappingGenerator(Map<String, CaptureHeadersSpec> captureHeaders, RequestBodyPatternFactory requestBodyPatternFactory, boolean markStubsPersistent) {
        this(new RequestPatternTransformer(captureHeaders, requestBodyPatternFactory), new LoggedResponseDefinitionTransformer(), markStubsPersistent);
    }

    @Override
    public StubMapping apply(ServeEvent event) {
        RequestPattern requestPattern = this.requestTransformer.apply(event.getRequest()).build();
        ResponseDefinition responseDefinition = this.responseTransformer.apply(event.getResponse());
        URI uri = URI.create(event.getRequest().getUrl());
        FilenameMaker filenameMaker = new FilenameMaker();
        return StubMapping.builder().setRequest(requestPattern).setResponse(responseDefinition).setPersistent(this.markStubsPersistent ? Boolean.valueOf(true) : null).setName(filenameMaker.sanitizeUrl(uri.getPath())).build();
    }
}

