/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class ScenarioProcessor {
    ScenarioProcessor() {
    }

    List<StubMapping> putRepeatedRequestsInScenarios(List<StubMapping> stubMappings) {
        Map stubsGroupedByRequest = stubMappings.stream().collect(Collectors.groupingBy(StubMapping::getRequest, LinkedHashMap::new, Collectors.toCollection(LinkedList::new)));
        Map groupsWithMoreThanOneStub = stubsGroupedByRequest.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (entry1, entry2) -> entry1, LinkedHashMap::new));
        LinkedList<StubMapping> stubsInScenario = new LinkedList<StubMapping>();
        int scenarioIndex = 0;
        for (Map.Entry entry3 : groupsWithMoreThanOneStub.entrySet()) {
            LinkedList<StubMapping> batch = new LinkedList<StubMapping>((Collection)entry3.getValue());
            Collections.reverse(batch);
            stubsInScenario.addAll(this.putStubsInScenario(++scenarioIndex, batch));
        }
        Map stubsInScenarioById = stubsInScenario.stream().collect(Collectors.toMap(StubMapping::getId, Function.identity()));
        return stubMappings.stream().map(originalStub -> stubsInScenarioById.getOrDefault(originalStub.getId(), originalStub)).toList();
    }

    private List<StubMapping> putStubsInScenario(int scenarioIndex, List<StubMapping> stubMappings) {
        StubMapping firstScenario = stubMappings.get(0);
        String scenarioName = "scenario-" + scenarioIndex + "-" + Urls.urlToPathParts(URI.create(ParameterUtils.getFirstNonNull(firstScenario.getRequest().getUrl(), firstScenario.getRequest().getUrlPath())));
        return IntStream.range(1, stubMappings.size() + 1).mapToObj(i -> ((StubMapping)stubMappings.get(i - 1)).transform(stub -> {
            stub.setScenarioName(scenarioName);
            if (i == 1) {
                stub.setRequiredScenarioState("Started");
            } else {
                stub.setRequiredScenarioState(scenarioName + "-" + i);
            }
            if (i < stubMappings.size()) {
                stub.setNewScenarioState(scenarioName + "-" + (i + 1));
            }
        })).collect(Collectors.toList());
    }
}

