/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.proxy;

import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.extension.ResponseTransformerV2;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ProxiedHostnameRewriteResponseTransformer
implements ResponseTransformerV2 {
    private static final String possibleSchemePrefixes = "[^a-zA-Z0-9+-.]";
    private static final String possibleHostPrefix = "[^a-zA-Z0-9-.!$&'()*+,;=:/]";
    private static final String possibleHostPostfix = "[^a-zA-Z0-9-.!$&'()*+,;=:]";
    private static final String possiblePortPostfix = "\\D";

    @Override
    public Response transform(Response response, ServeEvent serveEvent) {
        if (!serveEvent.getResponseDefinition().isProxyResponse()) {
            return response;
        }
        SubstitutionData substitutionData = ProxiedHostnameRewriteResponseTransformer.getSubstitutionData(serveEvent);
        List<HttpHeader> updatedHeaderList = response.getHeaders().all().stream().map(header -> new HttpHeader(header.key(), (Collection<String>)header.values().stream().map(value -> ProxiedHostnameRewriteResponseTransformer.applySubstitutions(value, substitutionData)).toList())).toList();
        HttpHeaders updatedHeaders = new HttpHeaders(updatedHeaderList);
        Response.Builder responseBuilder = Response.Builder.like(response).headers(updatedHeaders);
        byte[] initialBody = response.getBody();
        if (initialBody != null && initialBody.length > 0 && ContentTypes.determineIsTextFromMimeType(ProxiedHostnameRewriteResponseTransformer.getMimeType(response))) {
            byte[] updatedBody;
            if (Gzip.isGzipped(initialBody)) {
                String uncompressedBody = Gzip.unGzipToString(initialBody);
                uncompressedBody = ProxiedHostnameRewriteResponseTransformer.applySubstitutions(uncompressedBody, substitutionData);
                updatedBody = Gzip.gzip(uncompressedBody.getBytes());
            } else {
                String responseBodyAsString = response.getBodyAsString();
                responseBodyAsString = ProxiedHostnameRewriteResponseTransformer.applySubstitutions(responseBodyAsString, substitutionData);
                updatedBody = responseBodyAsString.getBytes();
            }
            responseBuilder.body(updatedBody);
            if (updatedHeaders.getHeader("Content-Length").isPresent()) {
                responseBuilder.headers(ProxiedHostnameRewriteResponseTransformer.setContentLengthHeader(updatedHeaders, String.valueOf(updatedBody.length)));
            }
        }
        return responseBuilder.build();
    }

    private static String applySubstitutions(String input, SubstitutionData data) {
        return data.combinedPattern.matcher(input).replaceAll(data::getReplacement);
    }

    @Override
    public String getName() {
        return "proxied-hostname-rewrite";
    }

    @Override
    public boolean applyGlobally() {
        return false;
    }

    private static HttpHeaders setContentLengthHeader(HttpHeaders headers, String value) {
        List<HttpHeader> filteredHeaders = headers.all().stream().filter(h -> !h.keyEquals("Content-Length")).collect(Collectors.toList());
        filteredHeaders.add(new HttpHeader("Content-Length", value));
        return new HttpHeaders(filteredHeaders);
    }

    private static String getMimeType(Response response) {
        HttpHeaders responseHeaders = response.getHeaders();
        return responseHeaders != null && responseHeaders.getContentTypeHeader() != null ? responseHeaders.getContentTypeHeader().mimeTypePart() : null;
    }

    private static SubstitutionData getSubstitutionData(ServeEvent serveEvent) {
        URI proxyUrl = URI.create(serveEvent.getRequest().getAbsoluteUrl());
        int proxyDefaultPort = ProxiedHostnameRewriteResponseTransformer.getDefaultPort(proxyUrl.getScheme());
        int proxyActualPort = proxyUrl.getPort() == -1 ? proxyDefaultPort : proxyUrl.getPort();
        String proxyWsScheme = ProxiedHostnameRewriteResponseTransformer.getWebSocketScheme(proxyUrl);
        URI originUrl = URI.create(serveEvent.getResponseDefinition().getProxyBaseUrl());
        int originDefaultPort = ProxiedHostnameRewriteResponseTransformer.getDefaultPort(originUrl.getScheme());
        int originActualPort = originUrl.getPort() == -1 ? originDefaultPort : originUrl.getPort();
        String originWsScheme = ProxiedHostnameRewriteResponseTransformer.getWebSocketScheme(originUrl);
        LinkedHashMap<Pattern, String> replacements = new LinkedHashMap<Pattern, String>();
        if (originActualPort == originDefaultPort) {
            if (proxyActualPort == proxyDefaultPort) {
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost(), originActualPort), proxyUrl.getScheme() + "://" + proxyUrl.getHost() + ":" + proxyActualPort);
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost()), proxyUrl.getScheme() + "://" + proxyUrl.getHost());
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost(), originActualPort), proxyWsScheme + "://" + proxyUrl.getHost() + ":" + proxyActualPort);
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost()), proxyWsScheme + "://" + proxyUrl.getHost());
                replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost(), originActualPort), proxyUrl.getHost() + ":" + proxyActualPort);
                replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost()), proxyUrl.getHost());
                replacements.put(ProxiedHostnameRewriteResponseTransformer.pattern("[^:]", "//" + originUrl.getHost(), possibleHostPrefix), "//" + proxyUrl.getHost());
            } else {
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost(), originActualPort), proxyUrl.getScheme() + "://" + proxyUrl.getHost() + ":" + proxyActualPort);
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost()), proxyUrl.getScheme() + "://" + proxyUrl.getHost() + ":" + proxyActualPort);
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost(), originActualPort), proxyWsScheme + "://" + proxyUrl.getHost() + ":" + proxyActualPort);
                replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost()), proxyWsScheme + "://" + proxyUrl.getHost() + ":" + proxyActualPort);
                replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost(), originActualPort), proxyUrl.getHost() + ":" + proxyActualPort);
                replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost()), proxyUrl.getHost() + ":" + proxyActualPort);
                replacements.put(ProxiedHostnameRewriteResponseTransformer.pattern("[^:]", "//" + originUrl.getHost(), possibleHostPrefix), proxyUrl.getScheme() + "://" + proxyUrl.getHost() + ":" + proxyActualPort);
            }
        } else if (proxyActualPort == proxyDefaultPort) {
            replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost(), originActualPort), proxyUrl.getScheme() + "://" + proxyUrl.getHost());
            replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost(), originActualPort), proxyWsScheme + "://" + proxyUrl.getHost());
            replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost(), originActualPort), proxyUrl.getHost());
            replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost()), proxyUrl.getHost());
        } else {
            replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originUrl.getScheme(), originUrl.getHost(), originActualPort), proxyUrl.getScheme() + "://" + proxyUrl.getHost() + ":" + proxyActualPort);
            replacements.put(ProxiedHostnameRewriteResponseTransformer.fullUrlPattern(originWsScheme, originUrl.getHost(), originActualPort), proxyWsScheme + "://" + proxyUrl.getHost() + ":" + proxyActualPort);
            replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost(), originActualPort), proxyUrl.getHost() + ":" + proxyActualPort);
            replacements.put(ProxiedHostnameRewriteResponseTransformer.schemelessPattern(originUrl.getHost()), proxyUrl.getHost());
        }
        return new SubstitutionData(replacements);
    }

    private static Pattern fullUrlPattern(String scheme, String host) {
        return ProxiedHostnameRewriteResponseTransformer.pattern(possibleSchemePrefixes, scheme + "://" + host, possibleHostPostfix);
    }

    private static Pattern fullUrlPattern(String scheme, String host, int port) {
        return ProxiedHostnameRewriteResponseTransformer.pattern(possibleSchemePrefixes, scheme + "://" + host + ":" + port, possiblePortPostfix);
    }

    private static Pattern schemelessPattern(String host) {
        return ProxiedHostnameRewriteResponseTransformer.pattern(possibleHostPrefix, host, possibleHostPostfix);
    }

    private static Pattern schemelessPattern(String host, int port) {
        return ProxiedHostnameRewriteResponseTransformer.pattern(possibleHostPrefix, host + ":" + port, possiblePortPostfix);
    }

    private static Pattern pattern(String prefixPattern, String literal, String postfixPattern) {
        return Pattern.compile("(?<=" + prefixPattern + "|^)" + Pattern.quote(literal) + "(?=" + postfixPattern + "|$)", 2);
    }

    private static String getWebSocketScheme(URI proxyUrl) {
        return proxyUrl.getScheme().equals("https") ? "wss" : "ws";
    }

    private static int getDefaultPort(String scheme) {
        return switch (scheme) {
            case "http", "ws" -> 80;
            case "https", "wss" -> 443;
            default -> -1;
        };
    }

    private static class SubstitutionData {
        private final Pattern combinedPattern;
        private final Map<String, String> replacementMap = new LinkedHashMap<String, String>();

        SubstitutionData(Map<Pattern, String> substitutions) {
            StringBuilder combinedPatternBuilder = new StringBuilder();
            int groupIndex = 0;
            for (Map.Entry<Pattern, String> entry : substitutions.entrySet()) {
                if (groupIndex > 0) {
                    combinedPatternBuilder.append("|");
                }
                String patternStr = entry.getKey().pattern();
                combinedPatternBuilder.append("(").append(patternStr).append(")");
                this.replacementMap.put(String.valueOf(groupIndex), entry.getValue());
                ++groupIndex;
            }
            this.combinedPattern = Pattern.compile(combinedPatternBuilder.toString(), 2);
        }

        String getReplacement(MatchResult matchResult) {
            for (int i = 1; i <= matchResult.groupCount(); ++i) {
                if (matchResult.group(i) == null) continue;
                return this.replacementMap.get(String.valueOf(i - 1));
            }
            return matchResult.group(0);
        }
    }
}

