/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePatternJsonDeserializer;
import java.io.IOException;

public class ContentPatternDeserialiser
extends JsonDeserializer<ContentPattern<?>> {
    public ContentPattern<?> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        if (rootNode.has("binaryEqualTo")) {
            return this.deserializeBinaryEqualTo(rootNode);
        }
        return new StringValuePatternJsonDeserializer().buildStringValuePattern(rootNode);
    }

    private BinaryEqualToPattern deserializeBinaryEqualTo(JsonNode rootNode) {
        String operand = rootNode.findValue("binaryEqualTo").textValue();
        return new BinaryEqualToPattern(operand);
    }
}

