/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class ResponseDefinition {
    private final int status;
    private final String statusMessage;
    private final Body body;
    private final String bodyFileName;
    private final HttpHeaders headers;
    private final HttpHeaders additionalProxyRequestHeaders;
    private final List<String> removeProxyRequestHeaders;
    private final Integer fixedDelayMilliseconds;
    private final DelayDistribution delayDistribution;
    private final ChunkedDribbleDelay chunkedDribbleDelay;
    private final String proxyBaseUrl;
    private final String proxyUrlPrefixToRemove;
    private final Fault fault;
    private final List<String> transformers;
    private final Parameters transformerParameters;
    private final String browserProxyUrl;
    private final Boolean wasConfigured;

    @JsonCreator
    public ResponseDefinition(@JsonProperty(value="status") int status, @JsonProperty(value="statusMessage") String statusMessage, @JsonProperty(value="body") String body, @JsonProperty(value="jsonBody") JsonNode jsonBody, @JsonProperty(value="base64Body") String base64Body, @JsonProperty(value="bodyFileName") String bodyFileName, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="additionalProxyRequestHeaders") HttpHeaders additionalProxyRequestHeaders, @JsonProperty(value="removeProxyRequestHeaders") List<String> removeProxyRequestHeaders, @JsonProperty(value="fixedDelayMilliseconds") Integer fixedDelayMilliseconds, @JsonProperty(value="delayDistribution") DelayDistribution delayDistribution, @JsonProperty(value="chunkedDribbleDelay") ChunkedDribbleDelay chunkedDribbleDelay, @JsonProperty(value="proxyBaseUrl") String proxyBaseUrl, @JsonProperty(value="proxyUrlPrefixToRemove") String proxyUrlPrefixToRemove, @JsonProperty(value="fault") Fault fault, @JsonProperty(value="transformers") List<String> transformers, @JsonProperty(value="transformerParameters") Parameters transformerParameters, @JsonProperty(value="fromConfiguredStub") Boolean wasConfigured) {
        this(status, statusMessage, Body.fromOneOf(null, body, jsonBody, base64Body), bodyFileName, headers, additionalProxyRequestHeaders, removeProxyRequestHeaders, fixedDelayMilliseconds, delayDistribution, chunkedDribbleDelay, proxyBaseUrl, proxyUrlPrefixToRemove, fault, transformers, transformerParameters, null, wasConfigured);
    }

    public ResponseDefinition(int status, String statusMessage, Body body, String bodyFileName, HttpHeaders headers, HttpHeaders additionalProxyRequestHeaders, List<String> removeProxyRequestHeaders, Integer fixedDelayMilliseconds, DelayDistribution delayDistribution, ChunkedDribbleDelay chunkedDribbleDelay, String proxyBaseUrl, String proxyUrlPrefixToRemove, Fault fault, List<String> transformers, Parameters transformerParameters, String browserProxyUrl, Boolean wasConfigured) {
        this.status = status > 0 ? status : 200;
        this.statusMessage = statusMessage;
        this.body = body;
        this.bodyFileName = bodyFileName;
        this.headers = headers;
        this.additionalProxyRequestHeaders = additionalProxyRequestHeaders;
        this.removeProxyRequestHeaders = removeProxyRequestHeaders != null ? List.copyOf(removeProxyRequestHeaders) : null;
        this.fixedDelayMilliseconds = fixedDelayMilliseconds;
        this.delayDistribution = delayDistribution;
        this.chunkedDribbleDelay = chunkedDribbleDelay;
        this.proxyBaseUrl = proxyBaseUrl == null ? null : proxyBaseUrl.trim();
        this.proxyUrlPrefixToRemove = proxyUrlPrefixToRemove;
        this.fault = fault;
        this.transformers = transformers != null ? List.copyOf(transformers) : null;
        this.transformerParameters = transformerParameters;
        this.browserProxyUrl = browserProxyUrl;
        this.wasConfigured = wasConfigured == null || wasConfigured != false;
    }

    public static ResponseDefinition notFound() {
        return new Builder().setStatus(404).build();
    }

    public static ResponseDefinition ok() {
        return new Builder().setStatus(200).build();
    }

    public static ResponseDefinition okEmptyJson() {
        return ResponseDefinitionBuilder.okForEmptyJson().build();
    }

    public static <T> ResponseDefinition okForJson(T body) {
        return ResponseDefinitionBuilder.okForJson(body).build();
    }

    public static ResponseDefinition created() {
        return new Builder().setStatus(201).build();
    }

    public static ResponseDefinition noContent() {
        return new Builder().setStatus(204).build();
    }

    public static ResponseDefinition badRequest(Errors errors) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(400).withHeader("Content-Type", "application/json").withBody(Json.write(errors)).build();
    }

    public static ResponseDefinition badRequestEntity(Errors errors) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(422).withHeader("Content-Type", "application/json").withBody(Json.write(errors)).build();
    }

    public static ResponseDefinition redirectTo(String path) {
        return new ResponseDefinitionBuilder().withHeader("Location", path).withStatus(302).build();
    }

    public static ResponseDefinition notConfigured() {
        return new Builder().setStatus(404).setWasConfigured(false).build();
    }

    public static ResponseDefinition notAuthorised() {
        return new Builder().setStatus(401).build();
    }

    public static ResponseDefinition notPermitted(String message) {
        return ResponseDefinition.notPermitted(Errors.single(40, message));
    }

    public static ResponseDefinition notPermitted(Errors errors) {
        return ResponseDefinitionBuilder.jsonResponse(errors, 403);
    }

    public static ResponseDefinition serverError() {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(500).build();
    }

    public static ResponseDefinition browserProxy(Request originalRequest) {
        return new Builder().setBrowserProxyUrl(originalRequest.getAbsoluteUrl()).build();
    }

    public static ResponseDefinition copyOf(ResponseDefinition original) {
        return original.copy();
    }

    public ResponseDefinition copy() {
        return new ResponseDefinition(this.status, this.statusMessage, this.body, this.bodyFileName, this.headers, this.additionalProxyRequestHeaders, this.removeProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.proxyUrlPrefixToRemove, this.fault, this.transformers, this.transformerParameters, null, this.wasConfigured);
    }

    public ResponseDefinition transform(Consumer<Builder> transformer) {
        Builder builder = this.toBuilder();
        transformer.accept(builder);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpHeaders getAdditionalProxyRequestHeaders() {
        return this.additionalProxyRequestHeaders;
    }

    public List<String> getRemoveProxyRequestHeaders() {
        return this.removeProxyRequestHeaders;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getBody() {
        return !this.body.isBinary() && !this.body.isJson() ? this.body.asString() : null;
    }

    @JsonIgnore
    public String getTextBody() {
        return !this.body.isBinary() ? this.body.asString() : null;
    }

    @JsonIgnore
    public byte[] getByteBody() {
        return this.body.asBytes();
    }

    @JsonIgnore
    public byte[] getByteBodyIfBinary() {
        return this.body.isBinary() ? this.body.asBytes() : null;
    }

    public String getBase64Body() {
        return this.body.isBinary() ? this.body.asBase64() : null;
    }

    @JsonIgnore
    public Body getReponseBody() {
        return this.body;
    }

    public JsonNode getJsonBody() {
        return this.body.isJson() ? this.body.asJson() : null;
    }

    public String getBodyFileName() {
        return this.bodyFileName;
    }

    public boolean wasConfigured() {
        return this.wasConfigured == null || this.wasConfigured != false;
    }

    public Boolean isFromConfiguredStub() {
        return this.wasConfigured == null || this.wasConfigured != false ? null : Boolean.valueOf(false);
    }

    public Integer getFixedDelayMilliseconds() {
        return this.fixedDelayMilliseconds;
    }

    public DelayDistribution getDelayDistribution() {
        return this.delayDistribution;
    }

    public ChunkedDribbleDelay getChunkedDribbleDelay() {
        return this.chunkedDribbleDelay;
    }

    public String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    public String getProxyUrlPrefixToRemove() {
        return this.proxyUrlPrefixToRemove;
    }

    @JsonIgnore
    public boolean specifiesBodyFile() {
        return this.bodyFileName != null && this.body.isAbsent();
    }

    @JsonIgnore
    public boolean specifiesBodyContent() {
        return this.body.isPresent();
    }

    @JsonIgnore
    public boolean specifiesTextBodyContent() {
        return this.body.isPresent() && !this.body.isBinary();
    }

    @JsonIgnore
    public boolean specifiesBinaryBodyContent() {
        return this.body.isPresent() && this.body.isBinary();
    }

    @JsonIgnore
    public boolean isProxyResponse() {
        return this.browserProxyUrl != null || this.proxyBaseUrl != null;
    }

    @JsonIgnore
    public String getBrowserProxyUrl() {
        return this.browserProxyUrl;
    }

    public Fault getFault() {
        return this.fault;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getTransformers() {
        return this.transformers;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Parameters getTransformerParameters() {
        return this.transformerParameters;
    }

    public boolean hasTransformer(Extension transformer) {
        return this.transformers != null && this.transformers.contains(transformer.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseDefinition that = (ResponseDefinition)o;
        return this.status == that.status && Objects.equals(this.statusMessage, that.statusMessage) && Objects.equals(this.body, that.body) && Objects.equals(this.bodyFileName, that.bodyFileName) && Objects.equals(this.headers, that.headers) && Objects.equals(this.additionalProxyRequestHeaders, that.additionalProxyRequestHeaders) && Objects.equals(this.removeProxyRequestHeaders, that.removeProxyRequestHeaders) && Objects.equals(this.fixedDelayMilliseconds, that.fixedDelayMilliseconds) && Objects.equals(this.delayDistribution, that.delayDistribution) && Objects.equals(this.chunkedDribbleDelay, that.chunkedDribbleDelay) && Objects.equals(this.proxyBaseUrl, that.proxyBaseUrl) && Objects.equals(this.proxyUrlPrefixToRemove, that.proxyUrlPrefixToRemove) && this.fault == that.fault && Objects.equals(this.transformers, that.transformers) && Objects.equals(this.transformerParameters, that.transformerParameters) && Objects.equals(this.browserProxyUrl, that.browserProxyUrl) && Objects.equals(this.wasConfigured, that.wasConfigured);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.statusMessage, this.body, this.bodyFileName, this.headers, this.additionalProxyRequestHeaders, this.removeProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.proxyUrlPrefixToRemove, this.fault, this.transformers, this.transformerParameters, this.browserProxyUrl, this.wasConfigured});
    }

    public String toString() {
        return this.wasConfigured != false ? Json.write(this) : "(no response definition configured)";
    }

    public static class Builder {
        private int status = 200;
        private String statusMessage;
        private Body body = Body.none();
        private String bodyFileName;
        private HttpHeaders headers;
        private HttpHeaders additionalProxyRequestHeaders;
        private List<String> removeProxyRequestHeaders;
        private Integer fixedDelayMilliseconds;
        private DelayDistribution delayDistribution;
        private ChunkedDribbleDelay chunkedDribbleDelay;
        private String proxyBaseUrl;
        private String proxyUrlPrefixToRemove;
        private Fault fault;
        private List<String> transformers;
        private Parameters transformerParameters;
        private String browserProxyUrl;
        private Boolean wasConfigured = true;
        private Request originalRequest;

        public Builder() {
        }

        public Builder(ResponseDefinition original) {
            this.status = original.status;
            this.statusMessage = original.statusMessage;
            this.body = original.body;
            this.bodyFileName = original.bodyFileName;
            this.headers = original.headers;
            this.additionalProxyRequestHeaders = original.additionalProxyRequestHeaders;
            this.removeProxyRequestHeaders = original.removeProxyRequestHeaders != null ? new ArrayList<String>(original.removeProxyRequestHeaders) : null;
            this.fixedDelayMilliseconds = original.fixedDelayMilliseconds;
            this.delayDistribution = original.delayDistribution;
            this.chunkedDribbleDelay = original.chunkedDribbleDelay;
            this.proxyBaseUrl = original.proxyBaseUrl;
            this.proxyUrlPrefixToRemove = original.proxyUrlPrefixToRemove;
            this.fault = original.fault;
            this.transformers = original.transformers != null ? new ArrayList<String>(original.transformers) : null;
            this.transformerParameters = original.transformerParameters;
            this.browserProxyUrl = original.browserProxyUrl;
            this.wasConfigured = original.wasConfigured;
        }

        public int getStatus() {
            return this.status;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public Body getBody() {
            return this.body;
        }

        public String getBodyFileName() {
            return this.bodyFileName;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public HttpHeaders getAdditionalProxyRequestHeaders() {
            return this.additionalProxyRequestHeaders;
        }

        public List<String> getRemoveProxyRequestHeaders() {
            return this.removeProxyRequestHeaders;
        }

        public Integer getFixedDelayMilliseconds() {
            return this.fixedDelayMilliseconds;
        }

        public DelayDistribution getDelayDistribution() {
            return this.delayDistribution;
        }

        public ChunkedDribbleDelay getChunkedDribbleDelay() {
            return this.chunkedDribbleDelay;
        }

        public String getProxyBaseUrl() {
            return this.proxyBaseUrl;
        }

        public String getProxyUrlPrefixToRemove() {
            return this.proxyUrlPrefixToRemove;
        }

        public Fault getFault() {
            return this.fault;
        }

        public List<String> getTransformers() {
            return this.transformers;
        }

        public Parameters getTransformerParameters() {
            return this.transformerParameters;
        }

        public String getBrowserProxyUrl() {
            return this.browserProxyUrl;
        }

        public Boolean getWasConfigured() {
            return this.wasConfigured;
        }

        public Request getOriginalRequest() {
            return this.originalRequest;
        }

        public Builder setStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder setBody(Body body) {
            this.body = body;
            return this;
        }

        public Builder setBodyFileName(String bodyFileName) {
            this.bodyFileName = bodyFileName;
            return this;
        }

        public Builder setHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder headers(Consumer<HttpHeaders.Builder> transformer) {
            this.headers = this.headers.transform(transformer);
            return this;
        }

        public Builder setAdditionalProxyRequestHeaders(HttpHeaders additionalProxyRequestHeaders) {
            this.additionalProxyRequestHeaders = additionalProxyRequestHeaders;
            return this;
        }

        public Builder setRemoveProxyRequestHeaders(List<String> removeProxyRequestHeaders) {
            this.removeProxyRequestHeaders = removeProxyRequestHeaders;
            return this;
        }

        public Builder setFixedDelayMilliseconds(Integer fixedDelayMilliseconds) {
            this.fixedDelayMilliseconds = fixedDelayMilliseconds;
            return this;
        }

        public Builder setDelayDistribution(DelayDistribution delayDistribution) {
            this.delayDistribution = delayDistribution;
            return this;
        }

        public Builder setChunkedDribbleDelay(ChunkedDribbleDelay chunkedDribbleDelay) {
            this.chunkedDribbleDelay = chunkedDribbleDelay;
            return this;
        }

        public Builder setProxyBaseUrl(String proxyBaseUrl) {
            this.proxyBaseUrl = proxyBaseUrl;
            return this;
        }

        public Builder setProxyUrlPrefixToRemove(String proxyUrlPrefixToRemove) {
            this.proxyUrlPrefixToRemove = proxyUrlPrefixToRemove;
            return this;
        }

        public Builder setFault(Fault fault) {
            this.fault = fault;
            return this;
        }

        public Builder setTransformers(List<String> transformers) {
            this.transformers = transformers;
            return this;
        }

        public Builder setTransformerParameters(Parameters transformerParameters) {
            this.transformerParameters = transformerParameters;
            return this;
        }

        public Builder setBrowserProxyUrl(String browserProxyUrl) {
            this.browserProxyUrl = browserProxyUrl;
            return this;
        }

        public Builder setWasConfigured(Boolean wasConfigured) {
            this.wasConfigured = wasConfigured;
            return this;
        }

        public Builder setOriginalRequest(Request originalRequest) {
            this.originalRequest = originalRequest;
            return this;
        }

        public ResponseDefinition build() {
            return new ResponseDefinition(this.status, this.statusMessage, this.body, this.bodyFileName, this.headers, this.additionalProxyRequestHeaders, this.removeProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, this.proxyUrlPrefixToRemove, this.fault, this.transformers, this.transformerParameters, this.browserProxyUrl, this.wasConfigured);
        }
    }
}

