/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.tomakehurst.wiremock.http.RequestMethodJsonDeserializer;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiRequestMethodPattern;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@JsonDeserialize(using=RequestMethodJsonDeserializer.class)
public class RequestMethod
implements NamedValueMatcher<RequestMethod> {
    public static final RequestMethod GET = new RequestMethod("GET");
    public static final RequestMethod POST = new RequestMethod("POST");
    public static final RequestMethod PUT = new RequestMethod("PUT");
    public static final RequestMethod DELETE = new RequestMethod("DELETE");
    public static final RequestMethod PATCH = new RequestMethod("PATCH");
    public static final RequestMethod OPTIONS = new RequestMethod("OPTIONS");
    public static final RequestMethod HEAD = new RequestMethod("HEAD");
    public static final RequestMethod TRACE = new RequestMethod("TRACE");
    public static final RequestMethod ANY = new RequestMethod("ANY");
    public static final RequestMethod GET_OR_HEAD = RequestMethod.isOneOf(GET, HEAD);
    public static final RequestMethod QUERY = new RequestMethod("QUERY");
    private static final List<RequestMethod> METHODS_WITH_ENTITY = Arrays.asList(PUT, PATCH, POST, QUERY);
    private final String name;

    public RequestMethod(String name) {
        if (name == null) {
            throw new NullPointerException("Method name cannot be null");
        }
        this.name = name;
    }

    public static RequestMethod fromString(String value) {
        return new RequestMethod(value);
    }

    public static Set<RequestMethod> fromStrings(Set<String> values) {
        return values.stream().map(RequestMethod::fromString).collect(Collectors.toSet());
    }

    public static RequestMethod isOneOf(RequestMethod ... methods) {
        return RequestMethod.isOneOf(RequestMethod.setOf(methods));
    }

    public static MultiRequestMethodPattern.IsOneOf isOneOf(Set<RequestMethod> methods) {
        return new MultiRequestMethodPattern.IsOneOf(methods);
    }

    public static RequestMethod isNoneOf(RequestMethod ... methods) {
        return RequestMethod.isNoneOf(RequestMethod.setOf(methods));
    }

    public static RequestMethod isNoneOf(Set<RequestMethod> methods) {
        return new MultiRequestMethodPattern.IsNoneOf(methods);
    }

    @SafeVarargs
    private static <T> Set<T> setOf(T ... items) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(Arrays.asList(items)));
    }

    @JsonValue
    public Object value() {
        return this.name;
    }

    @Override
    public MatchResult match(RequestMethod method) {
        return MatchResult.of(this.equals(ANY) || this.equals(method), new SubEvent[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpected() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestMethod that = (RequestMethod)o;
        return this.name.equals(that.name);
    }

    public boolean hasEntity() {
        return METHODS_WITH_ENTITY.contains(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static RequestMethod[] values() {
        return new RequestMethod[]{GET, POST, PUT, DELETE, PATCH, OPTIONS, HEAD, TRACE, ANY, GET_OR_HEAD, QUERY};
    }
}

