/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Metadata;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class Parameters
extends Metadata {
    public Parameters() {
    }

    @JsonCreator
    public Parameters(Map<? extends String, ?> data) {
        super(data);
    }

    @Override
    protected Metadata newInstance(Map<String, Object> value) {
        return new Parameters(value);
    }

    public static Parameters empty() {
        return new Parameters();
    }

    public static Parameters from(Map<String, Object> parameterMap) {
        return new Parameters(parameterMap);
    }

    public static Parameters one(String name, Object value) {
        return Parameters.from(Map.of(name, value));
    }

    public static <T> Parameters of(T myData) {
        return Parameters.from(Json.objectToMap(myData));
    }

    public Parameters getParameters(String key) {
        this.checkKeyPresent(key);
        ParameterUtils.checkParameter(Map.class.isAssignableFrom(this.get(key).getClass()), key + " is not a map");
        return new Parameters((Map)this.get(key));
    }

    public Parameters getParameters(String key, Parameters defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        ParameterUtils.checkParameter(Map.class.isAssignableFrom(this.get(key).getClass()), key + " is not a map");
        return new Parameters((Map)this.get(key));
    }

    @Override
    public Parameters transform(Consumer<Metadata.Builder> transformer) {
        Metadata.Builder builder = new Metadata.Builder(this);
        transformer.accept(builder);
        return Parameters.from(builder.build());
    }

    public Parameters merge(Parameters other) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(this);
        attributes.putAll(other);
        return Parameters.from(attributes);
    }

    public Parameters deepMerge(Parameters other) {
        return Parameters.from(super.deepMerge(other));
    }
}

