/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class Dates {
    public static Date parse(String dateString) {
        try {
            return Date.from(ZonedDateTime.parse(dateString).toInstant());
        }
        catch (DateTimeParseException e) {
            return Exceptions.throwUnchecked(e, Date.class);
        }
    }

    public static String format(Date date) {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(date.toInstant().atZone(ZoneId.of("Z")));
    }
}

