/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.ServeEventListenerDefinition;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.List;
import java.util.Map;

public class ServeEventListenerUtils {
    public static void triggerListeners(Map<String, ServeEventListener> serveEventListeners, ServeEventListener.RequestPhase requestPhase, ServeEvent serveEvent) {
        serveEventListeners.values().stream().filter(ServeEventListener::applyGlobally).forEach(listener -> listener.onEvent(requestPhase, serveEvent, Parameters.empty()));
        List<ServeEventListenerDefinition> serveEventListenerDefinitions = serveEvent.getServeEventListeners();
        for (ServeEventListenerDefinition listenerDef : serveEventListenerDefinitions) {
            ServeEventListener listener2 = serveEventListeners.get(listenerDef.getName());
            if (listener2 != null && !listener2.applyGlobally() && listenerDef.shouldFireFor(requestPhase)) {
                Parameters parameters = listenerDef.getParameters();
                listener2.onEvent(requestPhase, serveEvent, parameters);
                continue;
            }
            LocalNotifier.notifier().error("No per-stub listener was found named \"" + listenerDef.getName() + "\"");
        }
    }
}

