/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class WarClassloadingDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier JSTL = ModuleIdentifier.create((String)"javax.servlet.jstl.api");
    private static final ModuleIdentifier JBOSS_WEB = ModuleIdentifier.create((String)"org.jboss.as.web");
    private static final Logger logger;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSTL, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JBOSS_WEB, false, false, true, false));
    }

    public void undeploy(DeploymentUnit context) {
    }

    static {
        Module module = Module.forClass(WarClassloadingDependencyProcessor.class);
        if (module != null) {
            Module.registerURLStreamHandlerFactoryModule((Module)module);
        }
        logger = Logger.getLogger(WarClassloadingDependencyProcessor.class);
    }
}

