/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import java.security.AccessController;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.txn.subsystem.TransactionSubsystemRootResourceDefinition;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.tm.ExtendedJBossXATerminator;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.common.context.Contextual;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client.provider.jboss.JBossLocalTransactionProvider;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;

public final class LocalTransactionContextService
implements Service<LocalTransactionContext> {
    private final Consumer<LocalTransactionContext> contextConsumer;
    private final Supplier<ExtendedJBossXATerminator> extendedJBossXATerminatorSupplier;
    private final Supplier<TransactionManagerService> transactionManagerSupplier;
    private final Supplier<XAResourceRecoveryRegistry> xaResourceRecoveryRegistrySupplier;
    private final Supplier<ServerEnvironment> serverEnvironmentSupplier;
    private final int staleTransactionTime;
    private volatile LocalTransactionContext context;
    private JBossLocalTransactionProvider provider;

    public LocalTransactionContextService(Consumer<LocalTransactionContext> contextConsumer, Supplier<ExtendedJBossXATerminator> extendedJBossXATerminatorSupplier, Supplier<TransactionManagerService> transactionManagerSupplier, Supplier<XAResourceRecoveryRegistry> xaResourceRecoveryRegistrySupplier, Supplier<ServerEnvironment> serverEnvironmentSupplier, int staleTransactionTime) {
        this.contextConsumer = contextConsumer;
        this.extendedJBossXATerminatorSupplier = extendedJBossXATerminatorSupplier;
        this.transactionManagerSupplier = transactionManagerSupplier;
        this.xaResourceRecoveryRegistrySupplier = xaResourceRecoveryRegistrySupplier;
        this.serverEnvironmentSupplier = serverEnvironmentSupplier;
        this.staleTransactionTime = staleTransactionTime;
    }

    public void start(StartContext context) throws StartException {
        JBossLocalTransactionProvider.Builder builder = JBossLocalTransactionProvider.builder();
        builder.setExtendedJBossXATerminator(this.extendedJBossXATerminatorSupplier.get());
        builder.setTransactionManager(this.transactionManagerSupplier.get().getTransactionManager());
        builder.setXAResourceRecoveryRegistry(this.xaResourceRecoveryRegistrySupplier.get());
        builder.setXARecoveryLogDirRelativeToPath(this.serverEnvironmentSupplier.get().getServerDataDir().toPath());
        builder.setStaleTransactionTime(this.staleTransactionTime);
        this.provider = builder.build();
        LocalTransactionContext transactionContext = this.context = new LocalTransactionContext((LocalTransactionProvider)this.provider);
        this.contextConsumer.accept(transactionContext);
        AccessController.doPrivileged(() -> {
            LocalTransactionContext.getContextManager().setGlobalDefault((Contextual)transactionContext);
            return null;
        });
        context.getChildTarget().addService(TransactionSubsystemRootResourceDefinition.LOCAL_PROVIDER_CAPABILITY.getCapabilityServiceName()).setInstance((org.jboss.msc.Service)Service.NULL).install();
    }

    public void stop(StopContext context) {
        this.contextConsumer.accept(null);
        this.provider.removeXAResourceRecovery(this.xaResourceRecoveryRegistrySupplier.get());
        AccessController.doPrivileged(() -> {
            LocalTransactionContext.getContextManager().setGlobalDefault(null);
            return null;
        });
    }

    public LocalTransactionContext getValue() {
        return this.context;
    }
}

