/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadsMessages;
import org.jboss.as.threads.ThreadsWriteAttributeOperationHandler;
import org.jboss.as.threads.TimeSpec;
import org.jboss.as.threads.UnboundedQueueThreadPoolAdd;
import org.jboss.as.threads.UnboundedQueueThreadPoolService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class UnboundedQueueThreadPoolWriteAttributeHandler
extends ThreadsWriteAttributeOperationHandler {
    private final ServiceName serviceNameBase;

    public UnboundedQueueThreadPoolWriteAttributeHandler(ServiceName serviceNameBase) {
        super(UnboundedQueueThreadPoolAdd.ATTRIBUTES, UnboundedQueueThreadPoolAdd.RW_ATTRIBUTES);
        this.serviceNameBase = serviceNameBase;
    }

    @Override
    protected void applyOperation(OperationContext context, ModelNode model, String attributeName, ServiceController<?> service, boolean forRollback) throws OperationFailedException {
        UnboundedQueueThreadPoolService pool = (UnboundedQueueThreadPoolService)service.getService();
        if (PoolAttributeDefinitions.KEEPALIVE_TIME.getName().equals(attributeName)) {
            TimeUnit defaultUnit = pool.getKeepAliveUnit();
            TimeSpec spec = UnboundedQueueThreadPoolWriteAttributeHandler.getTimeSpec(context, model, defaultUnit);
            pool.setKeepAlive(spec);
        } else if (PoolAttributeDefinitions.MAX_THREADS.getName().equals(attributeName)) {
            pool.setMaxThreads(PoolAttributeDefinitions.MAX_THREADS.resolveModelAttribute(context, model).asInt());
        } else if (!forRollback) {
            throw ThreadsMessages.MESSAGES.unsupportedUnboundedQueueThreadPoolAttribute(attributeName);
        }
    }

    @Override
    protected ServiceController<?> getService(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)model.require("address"));
        ServiceName serviceName = this.serviceNameBase.append(new String[]{name});
        ServiceController controller = context.getServiceRegistry(true).getService(serviceName);
        if (controller == null) {
            throw ThreadsMessages.MESSAGES.unboundedQueueThreadPoolServiceNotFound(serviceName);
        }
        return controller;
    }
}

