/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.integration.ejb.interceptor.serverside;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.test.module.util.TestModule;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.as.test.shared.integration.ejb.interceptor.serverside.InterceptorModule;
import org.jboss.as.test.shared.integration.ejb.interceptor.serverside.InterceptorsSetupTask;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;

public abstract class AbstractServerInterceptorsSetupTask {

    public static class SetupTask
    implements ServerSetupTask,
    InterceptorsSetupTask {
        private List<InterceptorModule> interceptorModules = this.getModules();

        @Override
        public List<InterceptorModule> getModules() {
            return new ArrayList<InterceptorModule>();
        }

        @Override
        public void packModule(InterceptorModule module) throws Exception {
            URL url = module.getModuleXmlPath();
            if (url == null) {
                throw new IllegalStateException("Could not find " + module.getModuleXmlName());
            }
            File moduleXmlFile = new File(url.toURI());
            module.setTestModule(new TestModule(module.getModuleName(), moduleXmlFile));
            JavaArchive jar = module.getTestModule().addResource(module.getJarName());
            jar.addClass(module.getInterceptorClass());
            module.getTestModule().create(true);
        }

        @Override
        public void modifyServerInterceptors(List<InterceptorModule> interceptorModules, ManagementClient managementClient) throws Exception {
            ModelNode op = new ModelNode();
            op.get("address").set("subsystem", "ejb3");
            op.get("operation").set("write-attribute");
            op.get("name").set("server-interceptors");
            ModelNode value = new ModelNode();
            for (InterceptorModule module : interceptorModules) {
                ModelNode node = new ModelNode();
                node.get("module").set(module.getModuleName());
                node.get("class").set(module.getInterceptorClass().getName());
                value.add(node);
            }
            op.get("value").set(value);
            managementClient.getControllerClient().execute(op);
        }

        @Override
        public void revertServerInterceptors(ManagementClient managementClient) throws Exception {
            ModelNode op = new ModelNode();
            op.get("address").set("subsystem", "ejb3");
            op.get("operation").set("undefine-attribute");
            op.get("name").set("server-interceptors");
            ModelNode operationResult = managementClient.getControllerClient().execute(op);
            Assert.assertTrue((boolean)Operations.isSuccessfulOutcome((ModelNode)operationResult));
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            for (InterceptorModule module : this.interceptorModules) {
                this.packModule(module);
            }
            this.modifyServerInterceptors(this.interceptorModules, managementClient);
            ServerReload.executeReloadAndWaitForCompletion(managementClient);
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            for (InterceptorModule module : this.interceptorModules) {
                module.getTestModule().remove();
            }
            this.revertServerInterceptors(managementClient);
            ServerReload.executeReloadAndWaitForCompletion(managementClient);
        }
    }
}

