/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.servlets;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

@WebServlet(urlPatterns={"/readCredential"})
public class ReadCredentialServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/readCredential";
    public static final String PARAM_CREDENTIAL_STORE = "credentialStore";
    public static final String PARAM_ALIAS = "alias";
    public static final String PARAM_SEPARATOR = "separator";
    public static final String PARAM_SEPARATOR_DEFAULT = "\n";
    private static final ServiceName SERVICE_NAME_CRED_STORE = ServiceName.of((String[])new String[]{"org", "wildfly", "security", "credential-store"});

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("UTF-8");
        PrintWriter writer = resp.getWriter();
        String credentialStore = req.getParameter(PARAM_CREDENTIAL_STORE);
        String alias = req.getParameter(PARAM_ALIAS);
        String separator = req.getParameter(PARAM_SEPARATOR);
        if (separator == null) {
            separator = PARAM_SEPARATOR_DEFAULT;
        }
        ServiceContainer registry = CurrentServiceContainer.getServiceContainer();
        if (credentialStore == null || credentialStore.length() == 0) {
            for (ServiceName name : registry.getServiceNames()) {
                if (!SERVICE_NAME_CRED_STORE.equals(name.getParent())) continue;
                writer.print(name.getSimpleName());
                writer.print(separator);
            }
            return;
        }
        ServiceController credStoreService = registry.getService(ServiceName.of((ServiceName)SERVICE_NAME_CRED_STORE, (String[])new String[]{credentialStore}));
        if (credStoreService == null) {
            resp.setStatus(404);
            writer.print(credentialStore + " not found");
            return;
        }
        CredentialStore cs = (CredentialStore)credStoreService.getValue();
        if (alias == null || alias.length() == 0) {
            try {
                for (String csAlias : cs.getAliases()) {
                    writer.print(csAlias);
                    writer.print(separator);
                }
            }
            catch (UnsupportedOperationException | CredentialStoreException e) {
                throw new ServletException("Unable to list aliases", e);
            }
            return;
        }
        String clearPassword = null;
        try {
            Password password;
            if (cs.exists(alias, PasswordCredential.class) && (password = ((PasswordCredential)cs.retrieve(alias, PasswordCredential.class)).getPassword()) instanceof ClearPassword) {
                clearPassword = new String(((ClearPassword)password).getPassword());
            }
        }
        catch (IllegalStateException | CredentialStoreException e) {
            throw new ServletException("Unable to retrieve password  from credential store", e);
        }
        if (clearPassword == null) {
            resp.setStatus(404);
            writer.print(alias + " password not found in " + credentialStore);
        } else {
            writer.print(clearPassword);
        }
    }
}

