/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.other;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.other.ClientMapping;

public class SimpleSocketBinding
extends AbstractConfigurableElement {
    private final String socketBindingGroup;
    private final List<ClientMapping> clientMappings;
    private final Boolean fixedPort;
    private final String interfaceName;
    private final String multicastAddress;
    private final Integer multicastPort;
    private final Integer port;

    private SimpleSocketBinding(Builder builder) {
        super(builder);
        this.socketBindingGroup = builder.socketBindingGroup != null ? builder.socketBindingGroup : "standard-sockets";
        this.clientMappings = new ArrayList<ClientMapping>(builder.clientMappings);
        this.fixedPort = builder.fixedPort;
        this.interfaceName = builder.interfaceName;
        this.multicastAddress = builder.multicastAddress;
        this.multicastPort = builder.multicastPort;
        this.port = builder.port;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode op = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("socket-binding-group", this.socketBindingGroup).append("socket-binding", this.name));
        if (!this.clientMappings.isEmpty()) {
            ModelNode mappings = op.get("client-mappings");
            for (ClientMapping mapping : this.clientMappings) {
                mappings.add(mapping.toModelNode());
            }
        }
        ModelNodeUtil.setIfNotNull(op, "fixed-port", this.fixedPort);
        ModelNodeUtil.setIfNotNull(op, "interface", this.interfaceName);
        ModelNodeUtil.setIfNotNull(op, "multicast-address", this.multicastAddress);
        ModelNodeUtil.setIfNotNull(op, "multicast-port", this.multicastPort);
        ModelNodeUtil.setIfNotNull(op, "port", this.port);
        Utils.applyUpdate(op, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(Util.createRemoveOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("socket-binding-group", this.socketBindingGroup).append("socket-binding", this.name)), client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String socketBindingGroup;
        private List<ClientMapping> clientMappings = new ArrayList<ClientMapping>();
        private Boolean fixedPort;
        private String interfaceName;
        private String multicastAddress;
        private Integer multicastPort;
        private Integer port;

        private Builder() {
        }

        public Builder withSocketBindingGroup(String socketBindingGroup) {
            this.socketBindingGroup = socketBindingGroup;
            return this;
        }

        public Builder addClientMapping(ClientMapping clientMapping) {
            this.clientMappings.add(clientMapping);
            return this;
        }

        public Builder withFixedPort(Boolean fixedPort) {
            this.fixedPort = fixedPort;
            return this;
        }

        public Builder withInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
            return this;
        }

        public Builder withMulticastAddress(String multicastAddress) {
            this.multicastAddress = multicastAddress;
            return this;
        }

        public Builder withMulticastPort(Integer multicastPort) {
            this.multicastPort = multicastPort;
            return this;
        }

        public Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public SimpleSocketBinding build() {
            return new SimpleSocketBinding(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

