/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.ClientSslContext;

public class SimpleClientSslContext
extends AbstractConfigurableElement
implements ClientSslContext {
    private final String keyManager;
    private final String trustManager;
    private final String[] protocols;

    private SimpleClientSslContext(Builder builder) {
        super(builder);
        this.keyManager = builder.keyManagers;
        this.trustManager = builder.trustManager;
        this.protocols = builder.protocols;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder sb = new StringBuilder("/subsystem=elytron/client-ssl-context=").append(this.name).append(":add(");
        if (StringUtils.isNotBlank((CharSequence)this.keyManager)) {
            sb.append("key-manager=\"").append(this.keyManager).append("\", ");
        }
        if (this.protocols != null) {
            sb.append("protocols=[").append(Arrays.stream(this.protocols).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "))).append("], ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.trustManager)) {
            sb.append("trust-manager=\"").append(this.trustManager).append("\", ");
        }
        cli.sendLine(sb.toString());
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/client-ssl-context=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String keyManagers;
        private String trustManager;
        private String[] protocols;

        private Builder() {
        }

        public Builder withKeyManagers(String keyManagers) {
            this.keyManagers = keyManagers;
            return this;
        }

        public Builder withTrustManager(String trustManager) {
            this.trustManager = trustManager;
            return this;
        }

        public Builder withProtocols(String ... protocols) {
            this.protocols = protocols;
            return this;
        }

        public SimpleClientSslContext build() {
            return new SimpleClientSslContext(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

