/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.ConfigurableElement;

public class ConstantRealmMapper
implements ConfigurableElement {
    private final PathAddress address;
    private final String name;
    private final String realm;

    ConstantRealmMapper(String name, String realm) {
        this.name = name;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"constant-realm-mapper", (String)name)});
        this.realm = realm;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode addOperation = Util.createAddOperation((PathAddress)this.address);
        addOperation.get("realm-name").set(this.realm);
        Utils.applyUpdate(addOperation, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode removeOperation = Util.createRemoveOperation((PathAddress)this.address);
        Utils.applyUpdate(removeOperation, client);
    }

    public static ConfigurableElement newInstance(String name, String realm) {
        return new ConstantRealmMapper(name, realm);
    }
}

