/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import jakarta.enterprise.inject.spi.Extension;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.test.module.util.TestModule;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ModuleUtils {
    public static final String[] EE_DEPENDENCIES = new String[]{"javax.enterprise.api", "javax.inject.api", "javax.servlet.api", "javax.servlet.jsp.api"};
    public static final TestModule.ClassCallback ENTERPRISE_INJECT = new TestModule.ClassCallback(){

        public void classesAdded(JavaArchive jar, List<Class<?>> classes) {
            ArrayList extensions = new ArrayList(1);
            for (Class<?> clazz : classes) {
                if (!Extension.class.isAssignableFrom(clazz)) continue;
                extensions.add(clazz);
            }
            if (!extensions.isEmpty()) {
                Class[] a = (Class[])Array.newInstance(Extension.class.getClass(), 0);
                jar.addAsServiceProvider(Extension.class, extensions.toArray(a));
            }
        }
    };

    public static TestModule createTestModuleWithEEDependencies(String moduleName) {
        TestModule testModule = new TestModule("test." + moduleName, EE_DEPENDENCIES);
        return testModule;
    }
}

