/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.SecurityRealm;

public class JdbcSecurityRealm
implements SecurityRealm {
    private final PathAddress address;
    private final String name;
    private final List<ModelNode> principalQueries;
    private final String hashCharset;

    JdbcSecurityRealm(String name, List<ModelNode> principalQueries, String hashCharset) {
        this.name = name;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"jdbc-realm", (String)name)});
        this.principalQueries = principalQueries;
        this.hashCharset = hashCharset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ModelNode getAddOperation() {
        ModelNode addOperation = Util.createAddOperation((PathAddress)this.address);
        addOperation.get("principal-query").set(this.principalQueries);
        addOperation.get("hash-charset").set(this.hashCharset);
        return addOperation;
    }

    public ModelNode getRemoveOperation() {
        return Util.createRemoveOperation((PathAddress)this.address);
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getAddOperation(), client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(this.getRemoveOperation(), client);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private List<ModelNode> queries = new ArrayList<ModelNode>();
        private String hashCharset;

        Builder(String name) {
            this.name = name;
        }

        public PrincipalQueryBuilder withPrincipalQuery(String datasource, String sql) {
            return new PrincipalQueryBuilder(this, datasource, sql);
        }

        Builder addPrincipalQuery(ModelNode principalQuery) {
            this.queries.add(principalQuery);
            return this;
        }

        public Builder withHashCharset(String hashCharset) {
            this.hashCharset = hashCharset;
            return this;
        }

        public SecurityRealm build() {
            return new JdbcSecurityRealm(this.name, this.queries, this.hashCharset != null ? this.hashCharset : "UTF-8");
        }
    }

    public static enum Encoding {
        BASE64,
        HEX;

    }

    public static class PrincipalQueryBuilder {
        private final Builder builder;
        private final String datasource;
        private final String sql;
        private Map<String, ModelNode> passwordMappers = new LinkedHashMap<String, ModelNode>();
        private List<ModelNode> attributeMappers = new ArrayList<ModelNode>();

        PrincipalQueryBuilder(Builder builder, String datasource, String sql) {
            this.builder = builder;
            this.datasource = datasource;
            this.sql = sql;
        }

        public PrincipalQueryBuilder withPasswordMapper(String passwordType, String algorithm, int passwordIndex, int saltIndex, int iteractionCountIndex) {
            return this.withPasswordMapper(passwordType, algorithm, passwordIndex, Encoding.BASE64, saltIndex, Encoding.BASE64, iteractionCountIndex);
        }

        public PrincipalQueryBuilder withPasswordMapper(String passwordType, String algorithm, int passwordIndex, Encoding passwordEncoding, int saltIndex, Encoding saltEncoding, int iteractionCountIndex) {
            ModelNode passwordMapper = new ModelNode();
            if (algorithm != null) {
                passwordMapper.get("algorithm").set(algorithm);
            }
            passwordMapper.get("password-index").set(passwordIndex);
            if (passwordEncoding == Encoding.HEX) {
                passwordMapper.get("hash-encoding").set("hex");
            }
            if (saltIndex > 0) {
                passwordMapper.get("salt-index").set(saltIndex);
                if (saltEncoding == Encoding.HEX) {
                    passwordMapper.get("salt-encoding").set("hex");
                }
            }
            if (iteractionCountIndex > 0) {
                passwordMapper.get("iteration-count-index").set(iteractionCountIndex);
            }
            this.passwordMappers.put(passwordType, passwordMapper);
            return this;
        }

        public PrincipalQueryBuilder withAttributeMapper(String attributeName, int attributeIndex) {
            ModelNode attributeMapper = new ModelNode();
            attributeMapper.get("index").set(attributeIndex);
            attributeMapper.get("to").set(attributeName);
            this.attributeMappers.add(attributeMapper);
            return this;
        }

        public Builder build() {
            ModelNode principalQuery = new ModelNode();
            principalQuery.get("data-source").set(this.datasource);
            principalQuery.get("sql").set(this.sql);
            for (Map.Entry<String, ModelNode> mapper : this.passwordMappers.entrySet()) {
                principalQuery.get(mapper.getKey()).set(mapper.getValue());
            }
            if (this.attributeMappers.size() > 0) {
                principalQuery.get("attribute-mapping").set(this.attributeMappers);
            }
            return this.builder.addPrincipalQuery(principalQuery);
        }
    }
}

