/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.distribution.validation;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class ProvisioningConsistencyBaseTest {
    private static final Logger log = Logger.getLogger(ProvisioningConsistencyBaseTest.class);
    private static final String INSTALLATION = ".installation";
    private static final String PROVISIONING = ".wildfly-maven-plugin-provisioning.xml";
    private static final Path JBOSS_HOME = ProvisioningConsistencyBaseTest.resolveJBossHome();
    private final Path CHANNEL_INSTALLATION;
    private final Path INSTALLATION_METADATA;
    private final Path PROVISIONING_XML;
    private static final Path SOURCE_HOME = JBOSS_HOME.getParent().getParent().getParent().getParent().getParent();
    private static final Path DIST_INSTALLATION = JBOSS_HOME.getParent().resolve("wildfly-without-channel");

    private static Path resolveJBossHome() {
        try {
            return new File(System.getenv("JBOSS_HOME")).getCanonicalFile().toPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ProvisioningConsistencyBaseTest(String targetDist) {
        this.CHANNEL_INSTALLATION = SOURCE_HOME.resolve(targetDist);
        this.INSTALLATION_METADATA = this.CHANNEL_INSTALLATION.resolve(INSTALLATION);
        this.PROVISIONING_XML = this.CHANNEL_INSTALLATION.resolve(PROVISIONING);
    }

    @BeforeClass
    public static void assumeCompatibleEnvironment() throws IOException {
        ProvisioningConsistencyBaseTest.assumeJbossDistIsNotExternallySet();
    }

    private static void assumeJbossDistIsNotExternallySet() throws IOException {
        Path jbossDist = new File(System.getProperty("jboss.dist")).getCanonicalFile().toPath();
        Path defaultJbossDist = SOURCE_HOME.resolve(System.getProperty("build.output.dir"));
        Assume.assumeTrue((boolean)jbossDist.equals(defaultJbossDist));
    }

    @Test
    public void testInstallationEquivalence() throws IOException {
        final AtomicReference installationMetadata = new AtomicReference();
        final ArrayList<String> errors = new ArrayList<String>();
        Files.walkFileTree(this.CHANNEL_INSTALLATION, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                log.trace((Object)("Testing " + dir));
                if (dir.equals(ProvisioningConsistencyBaseTest.this.CHANNEL_INSTALLATION)) {
                    File distRoot = ProvisioningConsistencyBaseTest.this.getDistFile(dir, true, true, errors);
                    TreeSet<String> channelChildren = new TreeSet<String>(Arrays.asList(Objects.requireNonNull(dir.toFile().list())));
                    channelChildren.remove(ProvisioningConsistencyBaseTest.PROVISIONING);
                    TreeSet<String> distChildren = new TreeSet<String>(Arrays.asList(Objects.requireNonNull(distRoot.list())));
                    Assert.assertEquals((String)dir.toString(), channelChildren, distChildren);
                    return FileVisitResult.CONTINUE;
                }
                if (dir.equals(ProvisioningConsistencyBaseTest.this.INSTALLATION_METADATA)) {
                    File dist;
                    installationMetadata.set(dir);
                    File[] files = dir.toFile().listFiles();
                    if (files == null || files.length == 0) {
                        errors.add("No children for " + dir);
                    }
                    if ((files = (dist = ProvisioningConsistencyBaseTest.this.getDistFile(dir, true, true, errors)).listFiles()) != null && files.length > 0) {
                        errors.add(String.format("%s has unexpected files: %s", dist, Arrays.asList(files)));
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
                File distDir = ProvisioningConsistencyBaseTest.this.getDistFile(dir, true, true, errors);
                if (distDir != null) {
                    Assert.assertTrue((String)dir.toString(), (boolean)Objects.deepEquals(dir.toFile().list(), distDir.list()));
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                log.trace((Object)("Testing " + path));
                if (path.equals(ProvisioningConsistencyBaseTest.this.PROVISIONING_XML)) {
                    ProvisioningConsistencyBaseTest.this.getDistFile(path, false, false, errors);
                } else {
                    File distFile = ProvisioningConsistencyBaseTest.this.getDistFile(path, true, false, errors);
                    if (distFile != null && path.toFile().length() != distFile.length()) {
                        log.trace((Object)"File size is different");
                        if (!ProvisioningConsistencyBaseTest.sameJarContent(path, distFile.toPath(), errors)) {
                            errors.add(String.format("dist file for %s has an unexpected length: %d not %d", path, distFile.length(), path.toFile().length()));
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                throw exc;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        if (installationMetadata.get() == null) {
            errors.add("No .installation directory found");
        }
        if (!errors.isEmpty()) {
            Assert.fail((String)((Object)errors).toString());
        }
    }

    private File getDistFile(Path channelPath, boolean exists, boolean directory, List<String> errors) {
        return ProvisioningConsistencyBaseTest.getDistFile(this.CHANNEL_INSTALLATION, channelPath, DIST_INSTALLATION, exists, directory, errors);
    }

    private static File getDistFile(Path currentRoot, Path currentPath, Path distRoot, boolean exists, boolean directory, List<String> errors) {
        Path relative = currentRoot.relativize(currentPath);
        Path path = distRoot.resolve(relative);
        File test = path.toFile();
        File result = null;
        if (distRoot.equals(path)) {
            Assert.assertTrue((String)(path + " does not exist"), (boolean)test.exists());
            Assert.assertTrue((String)(path + " is not a directory"), (boolean)test.isDirectory());
            result = test;
        } else if (exists) {
            if (!test.exists()) {
                errors.add(String.format("%s %s does not exist", directory ? "Directory" : "File", path));
            } else if (test.isDirectory() != directory) {
                errors.add(String.format("%s %s %s a directory", directory ? "Directory" : "File", path, directory ? "is" : "is not"));
            } else {
                result = test;
            }
        } else if (test.exists()) {
            errors.add(String.format("%s %s should not exist", directory ? "Directory" : "File", path));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sameJarContent(Path current, Path dist, List<String> errors) {
        if (!dist.getFileName().toString().endsWith(".jar")) {
            return false;
        }
        log.trace((Object)("Checking jar " + current));
        Path tempFolder = null;
        try {
            tempFolder = Files.createTempDirectory("checkconsistency", new FileAttribute[0]);
            Path distUnzipped = tempFolder.resolve("dist");
            Path currentUnzipped = tempFolder.resolve("current");
            org.jboss.as.test.shared.FileUtils.unzipFile((Path)dist, (Path)distUnzipped);
            org.jboss.as.test.shared.FileUtils.unzipFile((Path)current, (Path)currentUnzipped);
            ProvisioningConsistencyBaseTest.checkContent(currentUnzipped, distUnzipped, errors);
            if (errors.isEmpty()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ex) {
            errors.add("Exception occurred when checking " + dist + " file content. " + ex);
        }
        finally {
            try {
                if (tempFolder != null) {
                    FileUtils.deleteDirectory((File)tempFolder.toFile());
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return false;
    }

    private static void checkContent(final Path currentRoot, final Path dist, final List<String> errors) throws IOException {
        Files.walkFileTree(currentRoot, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                log.trace((Object)("Testing " + dir));
                if (dir.equals(currentRoot)) {
                    File distRoot = ProvisioningConsistencyBaseTest.getDistFile(currentRoot, dir, dist, true, true, errors);
                    TreeSet<String> channelChildren = new TreeSet<String>(Arrays.asList(Objects.requireNonNull(dir.toFile().list())));
                    TreeSet<String> distChildren = new TreeSet<String>(Arrays.asList(Objects.requireNonNull(distRoot.list())));
                    Assert.assertEquals((String)dir.toString(), channelChildren, distChildren);
                    return FileVisitResult.CONTINUE;
                }
                File distDir = ProvisioningConsistencyBaseTest.getDistFile(currentRoot, dir, dist, true, true, errors);
                if (distDir != null) {
                    Assert.assertTrue((String)dir.toString(), (boolean)Objects.deepEquals(dir.toFile().list(), distDir.list()));
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                System.out.println("Checking " + path);
                File distFile = ProvisioningConsistencyBaseTest.getDistFile(currentRoot, path, dist, true, false, errors);
                if (distFile == null) {
                    errors.add(String.format("current file %s has not been found in %s", path, dist));
                } else {
                    try {
                        String hash1 = org.jboss.as.test.shared.FileUtils.computeHash((Path)path);
                        String hash2 = org.jboss.as.test.shared.FileUtils.computeHash((Path)distFile.toPath());
                        if (!hash1.equals(hash2)) {
                            errors.add(String.format("dist file for %s has an unexpected content", path));
                        }
                    }
                    catch (Exception ex) {
                        errors.add(String.format("dist file for %s has an unexpected length: %d not %d", path, distFile.length(), path.toFile().length()));
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                throw exc;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

