/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.undertow.common;

import java.util.Arrays;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.undertow.common.SingleSignOnSetting;

public class UndertowApplicationSecurityDomain
extends AbstractConfigurableElement {
    private final PathAddress address;
    private final String securityDomain;
    private final String httpAuthenticationFactory;
    private final boolean enableJacc;
    private final boolean enableJaspi;
    private final boolean integratedJaspi;
    private final SingleSignOnSetting singleSignOnSettings;

    UndertowApplicationSecurityDomain(Builder builder) {
        super(builder);
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "undertow").append("application-security-domain", this.name);
        this.securityDomain = builder.securityDomain;
        this.httpAuthenticationFactory = builder.httpAuthenticationFactory;
        this.enableJacc = builder.enableJacc;
        this.enableJaspi = builder.enableJaspi;
        this.integratedJaspi = builder.integratedJaspi;
        this.singleSignOnSettings = builder.singleSignOnSettings;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode add = Util.createAddOperation((PathAddress)this.address);
        ModelNodeUtil.setIfNotNull(add, "security-domain", this.securityDomain);
        ModelNodeUtil.setIfNotNull(add, "http-authentication-factory", this.httpAuthenticationFactory);
        if (this.enableJacc) {
            add.get("enable-jacc").set(this.enableJacc);
        }
        add.get("enable-jaspi").set(this.enableJaspi);
        add.get("integrated-jaspi").set(this.integratedJaspi);
        if (this.singleSignOnSettings != null) {
            ModelNode settingsAdd = this.singleSignOnSettings.getAddOperation(this.address);
            ModelNode composite = Util.createCompositeOperation(Arrays.asList(add, settingsAdd));
            Utils.applyUpdate(composite, client);
        } else {
            Utils.applyUpdate(add, client);
        }
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(Util.createRemoveOperation((PathAddress)this.address), client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String securityDomain;
        private String httpAuthenticationFactory;
        private boolean enableJacc = false;
        private boolean enableJaspi = true;
        private boolean integratedJaspi = true;
        private SingleSignOnSetting singleSignOnSettings = null;

        public Builder withSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder httpAuthenticationFactory(String httpAuthenticationFactory) {
            this.httpAuthenticationFactory = httpAuthenticationFactory;
            return this;
        }

        public Builder withEnableJacc(boolean enableJacc) {
            this.enableJacc = enableJacc;
            return this;
        }

        public Builder withEnableJaspi(boolean enableJaspi) {
            this.enableJaspi = enableJaspi;
            return this;
        }

        public Builder withIntegratedJaspi(boolean integratedJaspi) {
            this.integratedJaspi = integratedJaspi;
            return this;
        }

        public Builder withSingleSignOnSettings(SingleSignOnSetting singleSignOnSettings) {
            this.singleSignOnSettings = singleSignOnSettings;
            return this;
        }

        public UndertowApplicationSecurityDomain build() {
            return new UndertowApplicationSecurityDomain(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

