/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;

public class Module
extends AbstractConfigurableElement {
    private final List<String> resources;
    private final List<String> dependencies;

    Module(Builder builder) {
        super(builder);
        this.resources = builder.resources;
        this.dependencies = builder.dependencies;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder moduleAddCommand = new StringBuilder("module add --name=").append(this.name);
        if (this.resources.size() > 0) {
            moduleAddCommand.append(" --resources=");
            Iterator<String> resourcesIterator = this.resources.iterator();
            moduleAddCommand.append(resourcesIterator.next());
            while (resourcesIterator.hasNext()) {
                moduleAddCommand.append(",").append(resourcesIterator.next());
            }
        }
        if (this.dependencies.size() > 0) {
            moduleAddCommand.append(" --dependencies=");
            Iterator<String> dependenciesIterator = this.dependencies.iterator();
            moduleAddCommand.append(dependenciesIterator.next());
            while (dependenciesIterator.hasNext()) {
                moduleAddCommand.append(",").append(dependenciesIterator.next());
            }
        }
        cli.sendLine(moduleAddCommand.toString(), true);
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        String moduleRemove = "module remove --name=" + this.name;
        cli.sendLine(moduleRemove, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private List<String> resources = new ArrayList<String>();
        private List<String> dependencies = new ArrayList<String>();

        public Builder withResource(String resource) {
            this.resources.add(resource);
            return this;
        }

        public Builder withDependency(String dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Module build() {
            return new Module(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

