/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.shared.TestSuiteEnvironment;
import org.jboss.as.test.shared.TimeoutUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.xnio.IoUtils;

public class ServerReload {
    private static final Logger log = Logger.getLogger(ServerReload.class);
    public static final int TIMEOUT = 100000;

    @Deprecated
    public static void executeReloadAndWaitForCompletion(ModelControllerClient client) {
        ServerReload.executeReloadAndWaitForCompletion(client, 100000, false, null, -1, null);
    }

    @Deprecated
    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, String serverConfig) {
        ServerReload.executeReloadAndWaitForCompletion(client, 100000, false, null, -1, serverConfig);
    }

    @Deprecated
    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, boolean adminOnly) {
        ServerReload.executeReloadAndWaitForCompletion(client, 100000, adminOnly, null, -1, null);
    }

    @Deprecated
    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, int timeout) {
        ServerReload.executeReloadAndWaitForCompletion(client, timeout, false, null, -1, null);
    }

    public static void executeReloadAndWaitForCompletion(ManagementClient managementClient) {
        ServerReload.executeReloadAndWaitForCompletion(managementClient.getControllerClient(), 100000, false, managementClient.getMgmtAddress(), managementClient.getMgmtPort(), null);
    }

    public static void executeReloadAndWaitForCompletion(ManagementClient managementClient, String serverConfig) {
        ServerReload.executeReloadAndWaitForCompletion(managementClient.getControllerClient(), 100000, false, managementClient.getMgmtAddress(), managementClient.getMgmtPort(), serverConfig);
    }

    public static void executeReloadAndWaitForCompletion(ManagementClient managementClient, boolean adminOnly) {
        ServerReload.executeReloadAndWaitForCompletion(managementClient.getControllerClient(), 100000, adminOnly, managementClient.getMgmtAddress(), managementClient.getMgmtPort(), null);
    }

    public static void executeReloadAndWaitForCompletion(ManagementClient managementClient, int timeout) {
        ServerReload.executeReloadAndWaitForCompletion(managementClient.getControllerClient(), timeout, false, managementClient.getMgmtAddress(), managementClient.getMgmtPort(), null);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, int timeout, boolean adminOnly, String serverAddress, int serverPort) {
        ServerReload.executeReloadAndWaitForCompletion(client, timeout, adminOnly, serverAddress, serverPort, null);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, int timeout, boolean adminOnly, String serverAddress, int serverPort, String serverConfig) {
        ServerReload.executeReloadAndWaitForCompletion(client, timeout, adminOnly, false, serverAddress, serverPort, serverConfig);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, int timeout, boolean adminOnly, boolean startSuspended, String serverAddress, int serverPort, String serverConfig) {
        ServerReload.executeReload(client, adminOnly, startSuspended, serverConfig);
        ServerReload.waitForLiveServerToReload(timeout, serverAddress != null ? serverAddress : TestSuiteEnvironment.getServerAddress(), serverPort != -1 ? serverPort : TestSuiteEnvironment.getServerPort());
    }

    private static void executeReload(ModelControllerClient client, boolean adminOnly, String serverConfig) {
        ServerReload.executeReload(client, adminOnly, false, serverConfig);
    }

    private static void executeReload(ModelControllerClient client, boolean adminOnly, boolean startSuspended, String serverConfig) {
        block6: {
            ModelNode operation = new ModelNode();
            operation.get("address").setEmptyList();
            operation.get("operation").set("reload");
            if (adminOnly) {
                operation.get("admin-only").set(adminOnly);
            }
            if (startSuspended) {
                operation.get("start-mode").set("suspend");
            }
            if (serverConfig != null) {
                operation.get("server-config").set(serverConfig);
            }
            try {
                ModelNode result = client.execute(operation);
                if (!"success".equals(result.get("outcome").asString())) {
                    Assert.fail((String)("Reload operation didn't finish successfully: " + result.asString()));
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ExecutionException || cause instanceof CancellationException) break block6;
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForLiveServerToReload(int timeout, String serverAddress, int serverPort) {
        int adjustedTimeout = TimeoutUtil.adjust((int)timeout);
        long start = System.currentTimeMillis();
        ModelNode operation = new ModelNode();
        operation.get("address").setEmptyList();
        operation.get("operation").set("read-attribute");
        operation.get("name").set("server-state");
        while (System.currentTimeMillis() - start < (long)adjustedTimeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                ModelControllerClient liveClient = ModelControllerClient.Factory.create((String)serverAddress, (int)serverPort);
                try {
                    ModelNode result = liveClient.execute(operation);
                    if (!"running".equals(result.get("result").asString())) continue;
                    log.debugf("Server %s:%d was reloaded in %d milliseconds", (Object)serverAddress, (Object)serverPort, (Object)(System.currentTimeMillis() - start));
                    return;
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    IoUtils.safeClose((Closeable)liveClient);
                }
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.fail((String)("Live Server did not reload in the imparted time of " + adjustedTimeout + "(" + timeout + ") milliseconds"));
    }

    public static String getContainerRunningState(ManagementClient managementClient) throws IOException {
        return ServerReload.getContainerRunningState(managementClient.getControllerClient());
    }

    public static String getContainerRunningState(ModelControllerClient modelControllerClient) throws IOException {
        ModelNode operation = new ModelNode();
        operation.get("address").setEmptyList();
        operation.get("operation").set("read-attribute");
        operation.get("name").set("server-state");
        ModelNode rsp = modelControllerClient.execute(operation);
        return "success".equals(rsp.get("outcome").asString()) ? rsp.get("result").asString() : "failed";
    }

    @Deprecated
    public static void reloadIfRequired(ModelControllerClient controllerClient) throws Exception {
        String runningState = ServerReload.getContainerRunningState(controllerClient);
        if ("reload-required".equalsIgnoreCase(runningState)) {
            log.trace((Object)"Server reload is required. The reload will be executed.");
            ServerReload.executeReloadAndWaitForCompletion(controllerClient);
        } else {
            log.debugf("Server reload is not required; server-state is %s", (Object)runningState);
            Assert.assertEquals((String)"Server state 'running' is expected", (Object)"running", (Object)runningState);
        }
    }

    public static void reloadIfRequired(ManagementClient managementClient) throws Exception {
        String runningState = ServerReload.getContainerRunningState(managementClient);
        if ("reload-required".equalsIgnoreCase(runningState)) {
            log.trace((Object)"Server reload is required. The reload will be executed.");
            ServerReload.executeReloadAndWaitForCompletion(managementClient);
        } else {
            log.debugf("Server reload is not required; server-state is %s", (Object)runningState);
            Assert.assertEquals((String)"Server state 'running' is expected", (Object)"running", (Object)runningState);
        }
    }

    public static class AfterSetupTask
    implements ServerSetupTask {
        public static final AfterSetupTask INSTANCE = new AfterSetupTask();

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            ServerReload.reloadIfRequired(managementClient);
        }
    }

    public static class BeforeSetupTask
    implements ServerSetupTask {
        public static final BeforeSetupTask INSTANCE = new BeforeSetupTask();

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            ServerReload.reloadIfRequired(managementClient);
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        }
    }
}

