/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.servlets;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

@WebServlet(urlPatterns={"/printRoles"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"*"}))
public class RolePrintingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static String PARAM_ROLE_NAME = "role";
    public static final String SERVLET_PATH = "/printRoles";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        PrintWriter writer = resp.getWriter();
        String[] roleNames = req.getParameterValues(PARAM_ROLE_NAME);
        writer.write(",");
        if (roleNames != null) {
            for (String role : roleNames) {
                if (!req.isUserInRole(role)) continue;
                writer.write(role + ",");
            }
        }
        writer.close();
    }
}

