/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.SaslFilter;
import org.wildfly.test.security.common.elytron.SaslServerFactory;

public class SimpleConfigurableSaslServerFactory
extends AbstractConfigurableElement
implements SaslServerFactory {
    private final List<SaslFilter> filters;
    private final Map<String, String> properties;
    private final String protocol;
    private final String saslServerFactory;
    private final String serverName;

    private SimpleConfigurableSaslServerFactory(Builder builder) {
        super(builder);
        this.filters = builder.filters;
        this.properties = builder.properties;
        this.protocol = builder.protocol;
        this.saslServerFactory = Objects.requireNonNull(builder.saslServerFactory, "saslServerFactory must not be null");
        this.serverName = builder.serverName;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode op = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("configurable-sasl-server-factory", this.name));
        if (!this.filters.isEmpty()) {
            ModelNode filtersNode = op.get("filters");
            for (SaslFilter saslFilter : this.filters) {
                ModelNode saslFilterNode = new ModelNode();
                ModelNodeUtil.setIfNotNull(saslFilterNode, "predefined-filter", saslFilter.getPredefinedFilter());
                ModelNodeUtil.setIfNotNull(saslFilterNode, "pattern-filter", saslFilter.getPatternFilter());
                ModelNodeUtil.setIfNotNull(saslFilterNode, "enabling", saslFilter.isEnabling());
                filtersNode.add(saslFilterNode);
            }
        }
        if (!this.properties.isEmpty()) {
            ModelNode propertiesNode = op.get("properties");
            for (Map.Entry entry : this.properties.entrySet()) {
                propertiesNode.get((String)entry.getKey()).set((String)entry.getValue());
            }
        }
        ModelNodeUtil.setIfNotNull(op, "protocol", this.protocol);
        op.get("sasl-server-factory").set(this.saslServerFactory);
        ModelNodeUtil.setIfNotNull(op, "server-name", this.serverName);
        Utils.applyUpdate(op, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(Util.createRemoveOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("configurable-sasl-server-factory", this.name)), client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private List<SaslFilter> filters = new ArrayList<SaslFilter>();
        private Map<String, String> properties = new HashMap<String, String>();
        private String protocol;
        private String saslServerFactory;
        private String serverName;

        private Builder() {
        }

        public Builder addFilter(SaslFilter filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder addProperty(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder withProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withSaslServerFactory(String saslServerFactory) {
            this.saslServerFactory = saslServerFactory;
            return this;
        }

        public Builder withServerName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public SimpleConfigurableSaslServerFactory build() {
            return new SimpleConfigurableSaslServerFactory(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

