/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.other;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.x500.cert.X509CertificateBuilder;

public final class KeyUtils {
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final long DEFAULT_CERT_VALIDITY = 31536000L;
    private static final String DEFAULT_KEY_ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_SIZE = 2048;

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        return KeyUtils.generateKeyPair(DEFAULT_KEY_ALGORITHM, 2048);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.generateKeyPair();
    }

    public static X509Certificate generateX509Certificate(String name, KeyPair keyPair) throws CertificateException {
        return KeyUtils.generateX509Certificate(name, keyPair, 31536000L, SIGNATURE_ALGORITHM);
    }

    public static X509Certificate generateX509Certificate(String name, KeyPair keyPair, long certValidity, String signatureAlgorithm) throws CertificateException {
        ZonedDateTime from = ZonedDateTime.now();
        ZonedDateTime to = ZonedDateTime.now().plusSeconds(certValidity);
        BigInteger serialNumber = new BigInteger(64, new SecureRandom());
        X500Principal owner = new X500Principal("CN=" + name);
        X509CertificateBuilder certificateBuilder = new X509CertificateBuilder();
        return certificateBuilder.setIssuerDn(owner).setSubjectDn(owner).setNotValidBefore(from).setNotValidAfter(to).setSerialNumber(serialNumber).setPublicKey(keyPair.getPublic()).setSignatureAlgorithmName(signatureAlgorithm).setSigningKey(keyPair.getPrivate()).build();
    }
}

