/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.ConfigurableElement;

public class MappedRegexRealmMapper
implements ConfigurableElement {
    private final PathAddress address;
    private final String name;
    private final String pattern;
    private final String delegateRealmMapper;
    private final Map<String, String> realmMapping;

    MappedRegexRealmMapper(String name, String pattern, String delegateRealmMapper, Map<String, String> realmMapping) {
        this.name = name;
        this.address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"elytron"), PathElement.pathElement((String)"mapped-regex-realm-mapper", (String)name)});
        this.pattern = pattern;
        this.delegateRealmMapper = delegateRealmMapper;
        this.realmMapping = realmMapping;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode addOperation = Util.createAddOperation((PathAddress)this.address);
        addOperation.get("pattern").set(this.pattern);
        if (this.delegateRealmMapper != null) {
            addOperation.get("delegate-realm-mapper").set(this.delegateRealmMapper);
        }
        if (this.realmMapping.size() > 0) {
            ModelNode realmMapping = new ModelNode();
            for (Map.Entry<String, String> entry : this.realmMapping.entrySet()) {
                realmMapping.get(entry.getKey()).set(entry.getValue());
            }
            addOperation.get("realm-map").set(realmMapping);
        }
        Utils.applyUpdate(addOperation, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode removeOperation = Util.createRemoveOperation((PathAddress)this.address);
        Utils.applyUpdate(removeOperation, client);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private String pattern;
        private String delegateRealmMapper;
        private Map<String, String> realmMapping = new HashMap<String, String>();

        Builder(String name) {
            this.name = name;
        }

        public Builder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder withDelegateRealmMapper(String delegateRealmMapper) {
            this.delegateRealmMapper = delegateRealmMapper;
            return this;
        }

        public Builder withRealmMapping(String from, String to) {
            this.realmMapping.put(from, to);
            return this;
        }

        public MappedRegexRealmMapper build() {
            return new MappedRegexRealmMapper(this.name, this.pattern, this.delegateRealmMapper, this.realmMapping);
        }
    }
}

