/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.test.layers.LayersTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class LayersTestBase {
    public static final String[] NO_LAYER_COMMON = new String[]{"org.apache.activemq.artemis.protocol.amqp", "org.apache.activemq.artemis.protocol.hornetq", "org.apache.activemq.artemis.protocol.stomp", "org.hornetq.client", "org.jboss.as.xts"};
    public static final String[] NO_LAYER_WILDFLY_EE = new String[]{"org.apache.qpid.proton", "jakarta.data.api"};
    public static final String[] NO_LAYER_EXPANSION = new String[]{"org.wildfly.extension.microprofile.metrics-smallrye", "org.wildfly.extension.microprofile.opentracing-smallrye", "org.wildfly.reactive.dep.jts"};
    public static final String[] NO_LAYER_WILDFLY = new String[]{"org.wildfly.extension.mvc-krazo", "jakarta.mvc.api", "org.eclipse.krazo.core", "org.eclipse.krazo.resteasy", "org.wildfly.extension.jakarta.data", "jakarta.data.api"};
    public static final String[] NO_LAYER_WILDFLY_PREVIEW = new String[]{"org.wildfly.extension.metrics", "org.wildfly.extension.security.manager"};
    public static final String[] NOT_REFERENCED_COMMON = new String[]{"org.wildfly.naming", "org.jboss.resteasy.resteasy-json-binding-provider", "org.jboss.resteasy.resteasy-json-p-provider", "org.jboss.as.console", "org.jboss.as.domain-add-user", "org.jboss.as.domain-http-error-context", "org.jboss.as.jsf-injection", "org.jboss.as.product", "org.jboss.as.standalone", "org.jboss.logging.jul-to-slf4j-stub", "org.jboss.ws.tools.common", "org.jboss.ws.tools.wsconsume", "org.jboss.ws.tools.wsprovide", "gnu.getopt", "org.wildfly.security.elytron-tool", "org.wildfly.bootable-jar", "org.wildfly.security.jakarta.security", "org.jboss.as.system-jmx", "org.jboss.ws.saaj-impl", "org.jboss.ws.cxf.sts", "org.infinispan.cdi.common", "org.infinispan.cdi.embedded", "org.infinispan.cdi.remote", "org.infinispan.query", "org.infinispan.query.core", "org.jgroups.aws", "software.amazon.awssdk.s3", "org.jboss.mod_cluster.container.spi", "org.jboss.mod_cluster.core", "org.jboss.mod_cluster.load.spi", "org.wildfly.extension.elytron.jaas-realm", "org.wildfly.extension.mod_cluster", "org.wildfly.mod_cluster.undertow", "wildflyee.api"};
    public static final String[] NOT_REFERENCED_WILDFLY_EE = new String[0];
    public static final String[] NOT_REFERENCED_EXPANSION = new String[]{"org.wildfly.extension.microprofile.fault-tolerance-smallrye", "org.wildfly.microprofile.fault-tolerance-smallrye.deployment", "io.smallrye.fault-tolerance", "org.eclipse.microprofile.fault-tolerance.api", "org.wildfly.extension.microprofile.health-smallrye", "org.eclipse.microprofile.health.api", "io.smallrye.health", "org.wildfly.extension.microprofile.lra-coordinator", "org.wildfly.extension.microprofile.lra-participant", "org.jboss.narayana.lra.lra-service-base", "org.jboss.narayana.lra.lra-coordinator", "org.jboss.narayana.lra.lra-participant", "org.eclipse.microprofile.lra.api", "org.wildfly.extension.microprofile.openapi-smallrye", "org.eclipse.microprofile.openapi.api", "io.smallrye.openapi", "com.fasterxml.jackson.dataformat.jackson-dataformat-yaml", "org.wildfly.extension.microprofile.reactive-messaging-smallrye", "org.wildfly.extension.microprofile.telemetry", "org.wildfly.extension.microprofile.reactive-streams-operators-smallrye", "org.wildfly.reactive.mutiny.reactive-streams-operators.cdi-provider", "io.vertx.client", "org.wildfly.extension.microprofile.metrics-smallrye", "org.wildfly.extension.microprofile.opentracing-smallrye", "org.wildfly.extension.mvc-krazo", "jakarta.mvc.api", "org.eclipse.krazo.core", "org.eclipse.krazo.resteasy", "org.jboss.resteasy.microprofile.config", "org.jboss.resteasy.resteasy-client-microprofile"};
    public static final String[] NOT_REFERENCED_WILDFLY = new String[]{"org.wildfly.extension.micrometer", "org.wildfly.micrometer.deployment", "io.micrometer", "io.prometheus", "io.opentelemetry.proto", "org.wildfly.extension.mvc-krazo", "jakarta.mvc.api", "org.eclipse.krazo.core", "org.eclipse.krazo.resteasy", "org.wildfly.extension.jakarta.data"};
    public static final String[] NOT_REFERENCED_WILDFLY_PREVIEW = new String[]{"org.wildfly.extension.metrics", "org.wildfly.extension.mvc-krazo", "org.wildfly.extension.security.manager", "jakarta.mvc.api", "org.eclipse.krazo.core", "org.eclipse.krazo.resteasy", "org.hibernate.commons-annotations", "org.wildfly.extension.vertx"};
    public static final String[] NO_LAYER_OR_REFERENCE_COMMON = new String[]{"ibm.jdk", "javax.api", "javax.sql.api", "javax.xml.stream.api", "sun.jdk", "sun.scripting", "org.wildfly.security.http.sfbasic", "org.jboss.as.clustering.jgroups", "org.wildfly.extension.datasources-agroal", "io.agroal", "org.wildfly.extension.picketlink", "org.jboss.as.jsr77", "org.keycloak.keycloak-adapter-subsystem", "org.jboss.as.security", "org.eclipse.persistence", "org.jboss.genericjms", "org.jboss.as.appclient", "org.jboss.metadata.appclient", "org.bouncycastle", "org.jboss.resteasy.resteasy-rxjava2", "org.wildfly.security.jakarta.client.resteasy", "org.wildfly.security.jakarta.client.webservices", "org.wildfly.extension.rts", "org.jboss.narayana.rts"};
    public static final String[] NO_LAYER_OR_REFERENCE_WILDFLY_EE = new String[]{"io.reactivex.rxjava2.rxjava", "com.fasterxml.jackson.dataformat.jackson-dataformat-yaml", "org.wildfly.extension.jakarta.data"};
    private static final HashMap<String, List<String>> BANNED_MODULES_CONF = new HashMap<String, List<String>>(){
        {
            this.put("org.jboss.as.security", Arrays.asList("test-all-layers-jpa-distributed", "test-all-layers", "legacy-security", "test-standalone-reference"));
        }
    };
    protected static String root;
    private static String defaultConfigsRoot;
    private static LayersTest.ScanContext scanContext;

    protected abstract Set<String> getExpectedUnreferenced();

    protected abstract Set<String> getExpectedUnusedInAllLayers();

    protected static Set<String> concatArrays(String[] first, String[] ... others) {
        if (others == null || others.length == 0) {
            return new HashSet<String>(Arrays.asList(first));
        }
        Stream<String> stream = Arrays.stream(first);
        for (String[] array : others) {
            stream = Stream.concat(stream, Arrays.stream(array));
        }
        return stream.collect(Collectors.toSet());
    }

    @BeforeClass
    public static void setUp() {
        root = System.getProperty("layers.install.root");
        defaultConfigsRoot = System.getProperty("std.default.install.root");
        scanContext = new LayersTest.ScanContext(root);
    }

    @AfterClass
    public static void cleanUp() {
        boolean delete = Boolean.getBoolean("layers.delete.installations");
        if (delete) {
            File[] installations = new File(root).listFiles(File::isDirectory);
            if (installations != null) {
                for (File f : installations) {
                    LayersTest.recursiveDelete((Path)f.toPath());
                }
            }
            if ((installations = new File(defaultConfigsRoot).listFiles(File::isDirectory)) != null) {
                for (File f : installations) {
                    LayersTest.recursiveDelete((Path)f.toPath());
                }
            }
        }
    }

    @Test
    public void testLayersBoot() throws Exception {
        LayersTest.testLayersBoot((String)root);
    }

    @Test
    public void testLayersModuleUse() throws Exception {
        LayersTest.testLayersModuleUse(this.getExpectedUnusedInAllLayers(), (LayersTest.ScanContext)scanContext);
    }

    @Test
    public void testUnreferencedModules() throws Exception {
        LayersTest.testUnreferencedModules(this.getExpectedUnreferenced(), (LayersTest.ScanContext)scanContext);
    }

    @Test
    public void checkBannedModules() throws Exception {
        HashMap results = LayersTest.checkBannedModules((String)root, BANNED_MODULES_CONF);
        Assert.assertTrue((String)("The following banned modules were provisioned " + results.toString()), (boolean)results.isEmpty());
    }

    @Test
    public void testDefaultConfigs() throws Exception {
        LayersTest.testLayersBoot((String)defaultConfigsRoot);
    }
}

