/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.AbstractSocketBindingGroupAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.SocketBindingManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class BindingGroupAddHandler
extends AbstractSocketBindingGroupAddHandler {
    public static final BindingGroupAddHandler INSTANCE = new BindingGroupAddHandler();

    public static ModelNode getOperation(PathAddress address, ModelNode model) {
        ModelNode op = Util.createAddOperation((PathAddress)address);
        op.get("default-interface").set(model.get("default-interface"));
        op.get("port-offset").set(model.get("port-offset"));
        return op;
    }

    private BindingGroupAddHandler() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        final Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        this.populateModel(operation, model);
        SocketBindingGroupResourceDefinition.PORT_OFFSET.validateAndSet(operation, model);
        final PathAddress mine = PathAddress.pathAddress((ModelNode)operation.require("address"));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Set children = root.getChildren("socket-binding-group");
                if (children.size() > 1) {
                    for (Resource.ResourceEntry entry : children) {
                        if (entry.getName().equals(mine.getLastElement().getValue())) continue;
                        throw ServerMessages.MESSAGES.cannotAddMoreThanOneSocketBindingGroupForServer(mine, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)entry.getName())}));
                    }
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.MODEL);
        SocketBindingGroupResourceDefinition.validateDefaultInterfaceReference((OperationContext)context, (ModelNode)model);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        int portOffset = SocketBindingGroupResourceDefinition.PORT_OFFSET.resolveModelAttribute(context, model).asInt();
        String defaultInterface = SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.resolveModelAttribute(context, model).asString();
        SocketBindingManagerService service = new SocketBindingManagerService(portOffset);
        ServiceTarget serviceTarget = context.getServiceTarget();
        newControllers.add(serviceTarget.addService(SocketBindingManager.SOCKET_BINDING_MANAGER, (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{defaultInterface}), NetworkInterfaceBinding.class, service.getDefaultInterfaceBindingInjector()).addListener((ServiceListener)verificationHandler).install());
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        if (context.isBooting()) {
            super.rollbackRuntime(context, operation, model, controllers);
        } else {
            context.revertReloadRequired();
        }
    }
}

