/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ExplodedDeploymentMarker;
import org.jboss.as.server.deployment.MountExplodedMarker;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.server.deploymentoverlay.service.ContentService;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayIndexService;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayService;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class ContentOverrideDeploymentUnitProcessor
implements DeploymentUnitProcessor {
    private final DeploymentOverlayIndexService indexService;
    private static final AttachmentKey<AttachmentList<Closeable>> MOUNTED_FILES = AttachmentKey.createList(Closeable.class);

    public ContentOverrideDeploymentUnitProcessor(DeploymentOverlayIndexService indexService) {
        this.indexService = indexService;
    }

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        HashMap<String, ResourceRoot> resourceRootMap = new HashMap<String, ResourceRoot>();
        AttachmentList<ResourceRoot> rootList = deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS);
        if (rootList != null) {
            for (ResourceRoot root : rootList) {
                resourceRootMap.put(root.getRoot().getPathNameRelativeTo(deploymentRoot.getRoot()), root);
            }
        }
        boolean exploded = MountExplodedMarker.isMountExploded(deploymentUnit) && !ExplodedDeploymentMarker.isExplodedDeployment(deploymentUnit);
        HashSet<String> paths = new HashSet<String>();
        for (DeploymentOverlayService deploymentOverlay : this.indexService.getOverrides(deploymentUnit.getName())) {
            for (ContentService override : deploymentOverlay.getContentServices()) {
                try {
                    if (paths.contains(override.getPath())) continue;
                    VirtualFile mountPoint = deploymentRoot.getRoot().getChild(override.getPath());
                    if (resourceRootMap.containsKey(override.getPath())) {
                        ResourceRoot existingRoot = (ResourceRoot)resourceRootMap.get(override.getPath());
                        ContentOverrideDeploymentUnitProcessor.close(existingRoot.getMountHandle());
                        if (rootList != null) {
                            rootList.remove(existingRoot);
                        }
                        Closeable handle = VFS.mountZip((VirtualFile)override.getContentHash(), (VirtualFile)mountPoint, (TempFileProvider)TempFileProviderService.provider());
                        deploymentUnit.addToAttachmentList(MOUNTED_FILES, handle);
                        ResourceRoot newRoot = new ResourceRoot(override.getContentHash().getName(), mountPoint, new MountHandle(handle));
                        for (AttachmentKey<?> key : existingRoot.attachmentKeys()) {
                            newRoot.putAttachment(key, existingRoot.getAttachment(key));
                        }
                        for (FilterSpecification filter : existingRoot.getExportFilters()) {
                            newRoot.getExportFilters().add(filter);
                        }
                        deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, newRoot);
                        continue;
                    }
                    paths.add(override.getPath());
                    if (exploded) {
                        ContentOverrideDeploymentUnitProcessor.copyFile(override.getContentHash().getPhysicalFile(), mountPoint.getPhysicalFile());
                        continue;
                    }
                    Closeable handle = VFS.mountReal((File)override.getContentHash().getPhysicalFile(), (VirtualFile)mountPoint);
                    deploymentUnit.addToAttachmentList(MOUNTED_FILES, handle);
                }
                catch (IOException e) {
                    throw ServerMessages.MESSAGES.deploymentOverlayFailed(e, deploymentOverlay.getName(), override.getPath());
                }
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        for (Closeable closable : context.getAttachmentList(MOUNTED_FILES)) {
            try {
                closable.close();
            }
            catch (IOException e) {
                ServerLogger.DEPLOYMENT_LOGGER.failedToUnmountContentOverride(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        try {
            ContentOverrideDeploymentUnitProcessor.copyFile(in, dest);
        }
        finally {
            ContentOverrideDeploymentUnitProcessor.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream in, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        byte[] buff = new byte[1024];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        try {
            int i = in.read(buff);
            while (i > 0) {
                ((OutputStream)out).write(buff, 0, i);
                i = in.read(buff);
            }
        }
        finally {
            ContentOverrideDeploymentUnitProcessor.close(out);
        }
    }

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

