/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.resource.AbstractSocketBindingResourceDefinition;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.services.net.AbstractBindingWriteHandler;
import org.jboss.dmr.ModelNode;

public class BindingMulticastAddressHandler
extends AbstractBindingWriteHandler {
    public static final BindingMulticastAddressHandler INSTANCE = new BindingMulticastAddressHandler();

    private BindingMulticastAddressHandler() {
        super(new AttributeDefinition[]{AbstractSocketBindingResourceDefinition.MULTICAST_ADDRESS});
    }

    @Override
    void handleRuntimeChange(ModelNode operation, String attributeName, ModelNode attributeValue, SocketBinding binding) throws OperationFailedException {
        InetAddress address;
        if (attributeValue.isDefined()) {
            String addrString = attributeValue.asString();
            try {
                address = InetAddress.getByName(addrString);
            }
            catch (UnknownHostException e) {
                throw ServerMessages.MESSAGES.failedToResolveMulticastAddress(e, addrString);
            }
        } else {
            address = null;
        }
        binding.setMulticastAddress(address);
    }

    @Override
    void handleRuntimeRollback(ModelNode operation, String attributeName, ModelNode attributeValue, SocketBinding binding) {
        InetAddress address;
        if (attributeValue.isDefined()) {
            String addrString = attributeValue.asString();
            try {
                address = InetAddress.getByName(addrString);
            }
            catch (UnknownHostException e) {
                throw ServerMessages.MESSAGES.failedToResolveMulticastAddressForRollback(e, addrString);
            }
        } else {
            address = null;
        }
        binding.setMulticastAddress(address);
    }
}

