/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.dmr.ModelNode;

public abstract class AbstractDeploymentUploadHandler
implements OperationStepHandler {
    private final ContentRepository contentRepository;
    protected final AttributeDefinition attribute;

    protected AbstractDeploymentUploadHandler(ContentRepository contentRepository, AttributeDefinition attribute) {
        this.contentRepository = contentRepository;
        this.attribute = attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            this.attribute.validateOperation(operation);
            InputStream is = this.getContentInputStream(context, operation);
            try {
                byte[] hash = this.contentRepository.addContent(is);
                context.getResult().set(hash);
            }
            finally {
                AbstractDeploymentUploadHandler.safeClose(is);
            }
        }
        catch (IOException e) {
            throw ServerMessages.MESSAGES.caughtIOExceptionUploadingContent(e);
        }
        context.stepCompleted();
    }

    protected abstract InputStream getContentInputStream(OperationContext var1, ModelNode var2) throws IOException, OperationFailedException;

    private static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                ServerLogger.ROOT_LOGGER.caughtExceptionClosingContentInputStream(e);
            }
        }
    }
}

