/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.operations.common.ProcessReloadHandler;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public class ServerProcessReloadHandler
extends ProcessReloadHandler<RunningModeControl> {
    private static final AttributeDefinition USE_CURRENT_SERVER_CONFIG = new SimpleAttributeDefinitionBuilder("use-current-server-config", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ADMIN_ONLY, USE_CURRENT_SERVER_CONFIG};
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("reload", ServerDescriptions.getResourceDescriptionResolver("server")).setParameters(ATTRIBUTES).build();

    public ServerProcessReloadHandler(ServiceName rootService, RunningModeControl runningModeControl, ControlledProcessState processState) {
        super(rootService, runningModeControl, processState);
    }

    protected ProcessReloadHandler.ReloadContext<RunningModeControl> initializeReloadContext(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean unmanaged = context.getProcessType() != ProcessType.DOMAIN_SERVER;
        final boolean adminOnly = unmanaged && ADMIN_ONLY.resolveModelAttribute(context, operation).asBoolean(false);
        final boolean useCurrentConfig = unmanaged && USE_CURRENT_SERVER_CONFIG.resolveModelAttribute(context, operation).asBoolean(true);
        return new ProcessReloadHandler.ReloadContext<RunningModeControl>(){

            public void reloadInitiated(RunningModeControl runningModeControl) {
            }

            public void doReload(RunningModeControl runningModeControl) {
                runningModeControl.setRunningMode(adminOnly ? RunningMode.ADMIN_ONLY : RunningMode.NORMAL);
                runningModeControl.setReloaded();
                runningModeControl.setUseCurrentConfig(useCurrentConfig);
            }
        };
    }
}

