/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.operations.HttpManagementAddHandler;
import org.jboss.as.server.operations.HttpManagementRemoveHandler;
import org.jboss.dmr.ModelNode;

public class HttpManagementWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final OperationStepHandler INSTANCE = new HttpManagementWriteAttributeHandler();

    private HttpManagementWriteAttributeHandler() {
        super(HttpManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                if (model.hasDefined(HttpManagementResourceDefinition.INTERFACE.getName()) && (model.hasDefined(HttpManagementResourceDefinition.SOCKET_BINDING.getName()) || model.hasDefined(HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.getName()))) {
                    throw ServerMessages.MESSAGES.illegalCombinationOfHttpManagementInterfaceConfigurations(HttpManagementResourceDefinition.INTERFACE.getName(), HttpManagementResourceDefinition.SOCKET_BINDING.getName(), HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.getName());
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.MODEL);
        super.execute(context, operation);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return !context.isBooting();
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        ServiceVerificationHandler handler = new ServiceVerificationHandler();
        HttpManagementWriteAttributeHandler.updateHttpManagementService(context, subModel, handler);
        context.addStep((OperationStepHandler)handler, OperationContext.Stage.VERIFY);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel().clone();
        subModel.get(attributeName).set(valueToRestore);
        HttpManagementWriteAttributeHandler.updateHttpManagementService(context, subModel, null);
    }

    static void updateHttpManagementService(OperationContext context, ModelNode subModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        HttpManagementRemoveHandler.removeHttpManagementService(context);
        HttpManagementAddHandler.installHttpManagementConnector(context, subModel, context.getServiceTarget(), verificationHandler, null, false);
    }
}

