/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import io.undertow.server.handlers.ChannelUpgradeHandler;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.ManagementHttpServer;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class UndertowHttpManagementService
implements Service<HttpManagement> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"serverManagement", "controller", "management", "http"});
    public static final ServiceName HTTP_UPGRADE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"management", "http-upgrade"});
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<SocketBinding> injectedSocketBindingValue = new InjectedValue();
    private final InjectedValue<SocketBinding> injectedSecureSocketBindingValue = new InjectedValue();
    private final InjectedValue<NetworkInterfaceBinding> interfaceBindingValue = new InjectedValue();
    private final InjectedValue<SocketBindingManager> injectedSocketBindingManager = new InjectedValue();
    private final InjectedValue<Integer> portValue = new InjectedValue();
    private final InjectedValue<Integer> securePortValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceValue = new InjectedValue();
    private final InjectedValue<SecurityRealmService> securityRealmServiceValue = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> controlledProcessStateServiceValue = new InjectedValue();
    private final ConsoleMode consoleMode;
    private final String consoleSlot;
    private final boolean httpUpgrade;
    private ManagementHttpServer serverManagement;
    private SocketBindingManager socketBindingManager;
    private boolean useUnmanagedBindings = false;
    private ManagedBinding basicManagedBinding;
    private ManagedBinding secureManagedBinding;
    private HttpManagement httpManagement = new HttpManagement(){

        public InetSocketAddress getHttpSocketAddress() {
            return UndertowHttpManagementService.this.basicManagedBinding == null ? null : UndertowHttpManagementService.this.basicManagedBinding.getBindAddress();
        }

        public InetSocketAddress getHttpsSocketAddress() {
            return UndertowHttpManagementService.this.secureManagedBinding == null ? null : UndertowHttpManagementService.this.secureManagedBinding.getBindAddress();
        }

        @Override
        public int getHttpPort() {
            if (UndertowHttpManagementService.this.basicManagedBinding != null) {
                return UndertowHttpManagementService.this.basicManagedBinding.getBindAddress().getPort();
            }
            Integer port = (Integer)UndertowHttpManagementService.this.portValue.getOptionalValue();
            if (port != null) {
                return port;
            }
            return -1;
        }

        @Override
        public NetworkInterfaceBinding getHttpNetworkInterfaceBinding() {
            SocketBinding socketBinding;
            NetworkInterfaceBinding binding = (NetworkInterfaceBinding)UndertowHttpManagementService.this.interfaceBindingValue.getOptionalValue();
            if (binding == null && (socketBinding = (SocketBinding)UndertowHttpManagementService.this.injectedSocketBindingValue.getOptionalValue()) != null) {
                binding = socketBinding.getNetworkInterfaceBinding();
            }
            return binding;
        }

        @Override
        public int getHttpsPort() {
            if (UndertowHttpManagementService.this.secureManagedBinding != null) {
                return UndertowHttpManagementService.this.secureManagedBinding.getBindAddress().getPort();
            }
            Integer securePort = (Integer)UndertowHttpManagementService.this.securePortValue.getOptionalValue();
            if (securePort != null) {
                // empty if block
            }
            return -1;
        }

        @Override
        public NetworkInterfaceBinding getHttpsNetworkInterfaceBinding() {
            SocketBinding socketBinding;
            NetworkInterfaceBinding binding = (NetworkInterfaceBinding)UndertowHttpManagementService.this.interfaceBindingValue.getOptionalValue();
            if (binding == null && (socketBinding = (SocketBinding)UndertowHttpManagementService.this.injectedSecureSocketBindingValue.getOptionalValue()) != null) {
                binding = socketBinding.getNetworkInterfaceBinding();
            }
            return binding;
        }

        @Override
        public boolean hasConsole() {
            return UndertowHttpManagementService.this.consoleMode.hasConsole();
        }
    };

    public UndertowHttpManagementService(ConsoleMode consoleMode, String consoleSlot, boolean httpUpgrade) {
        this.consoleMode = consoleMode;
        this.consoleSlot = consoleSlot;
        this.httpUpgrade = httpUpgrade;
    }

    public synchronized void start(StartContext context) throws StartException {
        ChannelUpgradeHandler upgradeHandler;
        ModelController modelController = (ModelController)this.modelControllerValue.getValue();
        ControlledProcessStateService controlledProcessStateService = (ControlledProcessStateService)this.controlledProcessStateServiceValue.getValue();
        ExecutorService executorService = (ExecutorService)this.executorServiceValue.getValue();
        ModelControllerClient modelControllerClient = modelController.createClient((Executor)executorService);
        this.socketBindingManager = (SocketBindingManager)this.injectedSocketBindingManager.getOptionalValue();
        SecurityRealmService securityRealmService = (SecurityRealmService)this.securityRealmServiceValue.getOptionalValue();
        InetSocketAddress bindAddress = null;
        InetSocketAddress secureBindAddress = null;
        SocketBinding basicBinding = (SocketBinding)this.injectedSocketBindingValue.getOptionalValue();
        SocketBinding secureBinding = (SocketBinding)this.injectedSecureSocketBindingValue.getOptionalValue();
        NetworkInterfaceBinding interfaceBinding = (NetworkInterfaceBinding)this.interfaceBindingValue.getOptionalValue();
        if (interfaceBinding != null) {
            int securePort;
            this.useUnmanagedBindings = true;
            int port = (Integer)this.portValue.getOptionalValue();
            if (port > 0) {
                bindAddress = new InetSocketAddress(interfaceBinding.getAddress(), port);
            }
            if ((securePort = ((Integer)this.securePortValue.getOptionalValue()).intValue()) > 0) {
                secureBindAddress = new InetSocketAddress(interfaceBinding.getAddress(), securePort);
            }
        } else {
            if (basicBinding != null) {
                bindAddress = basicBinding.getSocketAddress();
            }
            if (secureBinding != null) {
                secureBindAddress = secureBinding.getSocketAddress();
            }
        }
        if (this.httpUpgrade) {
            upgradeHandler = new ChannelUpgradeHandler();
            context.getChildTarget().addService(HTTP_UPGRADE_SERVICE_NAME, (Service)new ValueService((Value)new ImmediateValue((Object)upgradeHandler))).install();
        } else {
            upgradeHandler = null;
        }
        try {
            this.serverManagement = ManagementHttpServer.create((InetSocketAddress)bindAddress, (InetSocketAddress)secureBindAddress, (int)50, (ModelControllerClient)modelControllerClient, (ExecutorService)executorService, (SecurityRealm)securityRealmService, (ControlledProcessStateService)controlledProcessStateService, (ConsoleMode)this.consoleMode, (String)this.consoleSlot, (ChannelUpgradeHandler)upgradeHandler);
            this.serverManagement.start();
            if (this.socketBindingManager != null) {
                if (this.useUnmanagedBindings) {
                    SocketBindingManager.UnnamedBindingRegistry registry = this.socketBindingManager.getUnnamedRegistry();
                    if (bindAddress != null) {
                        this.basicManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((String)"management-http", (InetSocketAddress)bindAddress, null);
                        registry.registerBinding(this.basicManagedBinding);
                    }
                    if (secureBindAddress != null) {
                        this.secureManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((String)"management-https", (InetSocketAddress)secureBindAddress, null);
                        registry.registerBinding(this.secureManagedBinding);
                    }
                } else {
                    SocketBindingManager.NamedManagedBindingRegistry registry = this.socketBindingManager.getNamedRegistry();
                    if (basicBinding != null) {
                        this.basicManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)basicBinding);
                        registry.registerBinding(this.basicManagedBinding);
                    }
                    if (secureBinding != null) {
                        this.secureManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)secureBinding);
                        registry.registerBinding(this.secureManagedBinding);
                    }
                }
            }
        }
        catch (BindException e) {
            StringBuilder sb = new StringBuilder().append(e.getMessage());
            if (bindAddress != null) {
                sb.append(" ").append(bindAddress);
            }
            if (secureBindAddress != null) {
                sb.append(" ").append(secureBindAddress);
            }
            throw new StartException(sb.toString(), (Throwable)e);
        }
        catch (Exception e) {
            throw ServerMessages.MESSAGES.failedToStartHttpManagementService(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        block8: {
            if (this.serverManagement != null) {
                SocketBindingManager.UnnamedBindingRegistry registry;
                try {
                    this.serverManagement.stop();
                    this.serverManagement = null;
                    if (this.socketBindingManager == null) break block8;
                    Object object = registry = this.useUnmanagedBindings ? this.socketBindingManager.getUnnamedRegistry() : this.socketBindingManager.getNamedRegistry();
                }
                catch (Throwable throwable) {
                    this.serverManagement = null;
                    if (this.socketBindingManager != null) {
                        SocketBindingManager.UnnamedBindingRegistry registry2;
                        Object object = registry2 = this.useUnmanagedBindings ? this.socketBindingManager.getUnnamedRegistry() : this.socketBindingManager.getNamedRegistry();
                        if (this.basicManagedBinding != null) {
                            registry2.unregisterBinding(this.basicManagedBinding);
                            this.basicManagedBinding = null;
                        }
                        if (this.secureManagedBinding != null) {
                            registry2.unregisterBinding(this.secureManagedBinding);
                            this.secureManagedBinding = null;
                        }
                        this.socketBindingManager = null;
                        this.useUnmanagedBindings = false;
                    }
                    throw throwable;
                }
                if (this.basicManagedBinding != null) {
                    registry.unregisterBinding(this.basicManagedBinding);
                    this.basicManagedBinding = null;
                }
                if (this.secureManagedBinding != null) {
                    registry.unregisterBinding(this.secureManagedBinding);
                    this.secureManagedBinding = null;
                }
                this.socketBindingManager = null;
                this.useUnmanagedBindings = false;
            }
        }
    }

    public HttpManagement getValue() throws IllegalStateException {
        return this.httpManagement;
    }

    public Injector<NetworkInterfaceBinding> getInterfaceInjector() {
        return this.interfaceBindingValue;
    }

    public Injector<SocketBindingManager> getSocketBindingManagerInjector() {
        return this.injectedSocketBindingManager;
    }

    public Injector<SocketBinding> getSocketBindingInjector() {
        return this.injectedSocketBindingValue;
    }

    public Injector<SocketBinding> getSecureSocketBindingInjector() {
        return this.injectedSecureSocketBindingValue;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executorServiceValue;
    }

    public Injector<Integer> getPortInjector() {
        return this.portValue;
    }

    public Injector<Integer> getSecurePortInjector() {
        return this.securePortValue;
    }

    public Injector<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }

    public InjectedValue<SecurityRealmService> getSecurityRealmInjector() {
        return this.securityRealmServiceValue;
    }

    public InjectedValue<ControlledProcessStateService> getControlledProcessStateServiceInjector() {
        return this.controlledProcessStateServiceValue;
    }
}

